package ru.yandex.autotests.directapi.clients.pingapi;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ApiAccessCredentials;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.AuthenticationData.APP_ACCEPTED_OFF;
import static ru.yandex.autotests.directapi.model.AuthenticationData.APP_ACCEPTED_TEST_REQUEST;
import static ru.yandex.autotests.directapi.model.AuthenticationData.APP_DECLINED_REQUEST;
import static ru.yandex.autotests.directapi.model.AuthenticationData.APP_DELETED_REQUEST;
import static ru.yandex.autotests.directapi.model.AuthenticationData.APP_NEW_FULL_REQUEST;
import static ru.yandex.autotests.directapi.model.AuthenticationData.APP_NEW_TEST_REQUEST;

/**
 * Author pavryabov
 * Date 26.09.14
 * https://st.yandex-team.ru/TESTIRT-2737
 */
@Aqua.Test
@Features(ClientFeatures.PING_API)
@Stories(ClientFeatures.APPLICATIONS_ACCESS)
@RunWith(Parameterized.class)
public class PingAPINegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String applicationDescription;

    @Parameterized.Parameter(1)
    public ApiAccessCredentials credentials;

    @Parameterized.Parameters(name = "Application = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"APP_NEW_FULL_REQUEST", APP_NEW_FULL_REQUEST},
                {"APP_NEW_TEST_REQUEST", APP_NEW_TEST_REQUEST},
                {"APP_ACCEPTED_TEST_REQUEST", APP_ACCEPTED_TEST_REQUEST},
                {"APP_DELETED_REQUEST", APP_DELETED_REQUEST},
                {"APP_DECLINED_REQUEST", APP_DECLINED_REQUEST},
                {"APP_ACCEPTED_OFF", APP_ACCEPTED_OFF},
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5799")
    public void checkAccessToAPI() {
        api.as(credentials.getLogin()).applicationID(credentials.getApplicationId()).userSteps
                .shouldGetErrorOn(Method.PING_API, (Object) null,
                        new AxisError(58, AxisErrorDetails.YOU_MUST_FILL_REQUEST_AND_WAIT_CONFIRMATION));
    }
}
