package ru.yandex.autotests.directapi.clients.pingapi;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ApiAccessCredentials;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.model.AuthenticationData.*;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author pavryabov
 * Date 26.09.14
 * https://st.yandex-team.ru/TESTIRT-2737
 */
@Aqua.Test
@Features(ClientFeatures.PING_API)
@Stories(ClientFeatures.APPLICATIONS_ACCESS)
@RunWith(Parameterized.class)
public class PingAPIPositiveTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String applicationDescription;

    @Parameterized.Parameter(1)
    public ApiAccessCredentials credentials;

    @Parameterized.Parameters(name = "Application = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"OLD_APP", OLD_APP},
                {"OLD_APP_NEW_REQUEST", OLD_APP_NEW_REQUEST},
                {"APP_ACCEPTED_FULL_REQUEST", APP_ACCEPTED_FULL_REQUEST},
                {"APP_ACCEPTED_AND_EDITED_REQUEST", APP_ACCEPTED_AND_EDITED_REQUEST},
                {"APP_NEW_ON", APP_NEW_ON},
                {"APP_DECLINED_ON", APP_DECLINED_ON},
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5800")
    public void checkAccessToAPI() {
        assertThat("PingAPI вернул правильный ответ",
                api.as(credentials.getLogin()).applicationID(credentials.getApplicationId())
                        .userSteps.pingAPISteps().pingAPI(), equalTo(1));
    }
}
