package ru.yandex.autotests.directapi.clients.production;

import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.*;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 29.04.14.
 * <p/>
 * Smoke-тесты на проверку некоторых методов на production окружении
 * https://jira.yandex-team.ru/browse/TESTIRT-1800
 */
@Aqua.Test
@Features(ApiFeatures.PRODUCTION)
@Stories(ClientFeatures.CREATE_CLIENT)
public class CreateNewSubclientProdTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class);

    private static final String CLIENT_BASE = "test-smoke-prod";
    private static final String agencyLogin =  Logins.AGENCY_SMOKE_PROD;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5801")
    public void createAgencySubclient() {
        CreateNewSubclientResponse client = api.protocol(ProtocolType.SOAP).as(agencyLogin).userSteps.clientSteps().createNewAgencySubClient(
                CLIENT_BASE,
                agencyLogin,
                Currency.RUB
        );
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        assertThat("корректная валюта клиента", clientInfo.getClientCurrencies()[0], equalTo(Currency.RUB.toString()));
    }
}
