package ru.yandex.autotests.directapi.clients.rights;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 03.12.14.
 */
@Aqua.Test
@Features(ClientFeatures.PING_API)
@Description("Доступ к АПИ привязан к ClientID: для представителя и клиента должен быть одинаковым. " +
        "По мотивам DIRECT-36816")
public class DisableApiForClientAndRepClientTest {
    private static LogSteps log = LogSteps.getLogger(DisableApiForClientAndRepClientTest.class);
    private static final String API_ENABLED = "api_enabled";
    private static String valueApiEnabled;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);
    private String apiEnabled;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareClient(){
        api.userSteps.clientFakeSteps().enableAPI(ClientLogins.CLIENT_WITH_REP2);
        valueApiEnabled =
                api.userSteps.clientFakeSteps().getClientData(ClientLogins.CLIENT_WITH_REP2,new String[]{API_ENABLED}).getAPIEnabled();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5802")
    public void setApiEnabledNoForClient(){
        assumeThat("доступ у клиента должен присутствовать", valueApiEnabled,equalTo(Value.YES));
        log.info("Выключаем доступ к АПИ у клиента.");
        api.userSteps.clientFakeSteps().disableAPI(ClientLogins.CLIENT_WITH_REP2);
        log.info("Проверяем, что галка изменилась.");
        apiEnabled = api.userSteps.clientFakeSteps().getClientData(
                ClientLogins.CLIENT_WITH_REP2,new String[]{API_ENABLED}).getAPIEnabled();
        assertThat("доступ к АПИ у клиента выключён.", apiEnabled, equalTo(Value.NO));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5803")
    public void setApiEnabledNoForRepClient(){
        assumeThat("доступ у клиента должен присутствовать", valueApiEnabled,equalTo(Value.YES));
        log.info("Выключаем доступ к АПИ у клиента.");
        api.userSteps.clientFakeSteps().disableAPI(ClientLogins.CLIENT_WITH_REP2);
        log.info("Проверяем, что выключился и у представителя.");
        apiEnabled =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.REP2_CLIENT,new String[]{API_ENABLED}).getAPIEnabled();
        assertThat("доступ к АПИ у представителя клиента выключён.", apiEnabled, equalTo(Value.NO));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5804")
    public void checkApiAccessForRepClient(){
        assumeThat("доступ у клиента должен присутствовать", valueApiEnabled,equalTo(Value.YES));
        log.info("Выключаем доступ к АПИ у клиента.");
        api.userSteps.clientFakeSteps().disableAPI(ClientLogins.CLIENT_WITH_REP2);
        log.info("Проверяем, что выключился и у представителя.");
        api.as(ClientLogins.REP2_CLIENT).userSteps.shouldGetErrorOn(Method.PING_API,
                (Object)null,
                new AxisError(510, AxisErrorDetails.ACCESS_DENIED)
        );
    }

}
