package ru.yandex.autotests.directapi.clients.rights;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 04.12.14.
 */
@Aqua.Test
@Features(ClientFeatures.SUBCLIENT_RIGHTS)
@Description("Проверка выставления галки \"право создания кампаний...\" для субклиента и его представителей." +
        "По мотивам DIRECT-35485")
public class DisableCreateCampaignForSubclientAndRepTest {
    private static LogSteps log = LogSteps.getLogger(DisableCreateCampaignForSubclientAndRepTest.class);
    private static final String ALLOW_CREATE_CAMPAIGNS = "allow_create_scamp_by_subclient";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private String valueAllowCreateCamp;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareSubClient(){
        api.userSteps.clientFakeSteps().enableToCreateSelfCampaigns(ClientLogins.SUBCLIENT_WITH_REP2);
        valueAllowCreateCamp =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.SUBCLIENT_WITH_REP2,new String[]{ALLOW_CREATE_CAMPAIGNS}
                ).getAllowCreateScampBySubclient();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5805")
    public void setAllowCreatCampNoForSubClient(){
        assumeThat("право создавать кампании у субклиента должно присутствовать.",
                valueAllowCreateCamp,equalTo("1"));
        log.info("Выключаем право создавать кампании у субклиента.");
        api.userSteps.clientFakeSteps().disableToCreateSelfCampaigns(ClientLogins.SUBCLIENT_WITH_REP2);
        log.info("Проверяем, что галка изменилась.");
        valueAllowCreateCamp =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.SUBCLIENT_WITH_REP2,new String[]{ALLOW_CREATE_CAMPAIGNS}
                ).getAllowCreateScampBySubclient();
        assertThat("право создавать кампании выключено.", valueAllowCreateCamp, equalTo("0"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5806")
    public void setAllowCreateCampNoForSubClientAndCheckForRep(){
        assumeThat("право создавать кампании у субклиента должно присутствовать.",
                valueAllowCreateCamp,equalTo("1"));
        log.info("Выключаем право создавать кампании у субклиента.");
        api.userSteps.clientFakeSteps().disableToCreateSelfCampaigns(ClientLogins.SUBCLIENT_WITH_REP2);
        log.info("Проверяем, что выключилось и у представителя.");
        valueAllowCreateCamp =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.FIRST_REP2_SUBCLIENT,new String[]{ALLOW_CREATE_CAMPAIGNS}
                ).getAllowCreateScampBySubclient();
        assertThat("право создавать кампании выключено.", valueAllowCreateCamp, equalTo("0"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5807")
    public void setAllowCreateCampNoForRepAndCheckForAnotherRep(){
        assumeThat("право создавать кампании у субклиента должно присутствовать.",
                valueAllowCreateCamp,equalTo("1"));
        log.info("Выключаем право создавать кампании у субклиента.");
        api.userSteps.clientFakeSteps().disableToCreateSelfCampaigns(ClientLogins.SECOND_REP2_SUBCLIENT);
        log.info("Проверяем, что выключилось и у представителя.");
        valueAllowCreateCamp =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.FIRST_REP2_SUBCLIENT,new String[]{ALLOW_CREATE_CAMPAIGNS}
                ).getAllowCreateScampBySubclient();
        assertThat("право создавать кампании выключено.", valueAllowCreateCamp, equalTo("0"));
    }

}
