package ru.yandex.autotests.directapi.clients.rights;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 04.12.14.
 */
@Aqua.Test
@Features(ClientFeatures.SUBCLIENT_RIGHTS)
@Description("Проверка выставления галки \"перенос средств\" для субклиента и его представителей." +
        "По мотивам DIRECT-35485")
public class DisableTransferMoneyFoSubclientAndRepTest {
    private static LogSteps log = LogSteps.getLogger(DisableEditCampaignForSubclientAndRepTest.class);
    private static final String DISALLOW_MONEY_TRANSFER = "disallow_money_transfer";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private int valueDisallowTransfer;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareSubClient(){
        api.userSteps.clientFakeSteps().enableDisallowMoneyTransfer(ClientLogins.SUBCLIENT_WITH_REP2);
        valueDisallowTransfer =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.SUBCLIENT_WITH_REP2,new String[]{DISALLOW_MONEY_TRANSFER}
                ).getDisallowMoneyTransfer();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5812")
    public void setDisallowTransferMoneyNoForSubClient(){
        assumeThat("право переноса средств у субклиента должно присутствовать.",
                valueDisallowTransfer,equalTo(1));
        log.info("Выключаем право переноса средств у субклиента.");
        api.userSteps.clientFakeSteps().disableDisallowMoneyTransfer(ClientLogins.SUBCLIENT_WITH_REP2);
        log.info("Проверяем, что галка изменилась.");
        valueDisallowTransfer =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.SUBCLIENT_WITH_REP2,new String[]{DISALLOW_MONEY_TRANSFER}
                ).getDisallowMoneyTransfer();
        assertThat("право переноса средств выключено.", valueDisallowTransfer, equalTo(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5811")
    public void setDisallowTransferMoneyNoForSubClientAndCheckForRep(){
        assumeThat("право переноса средств у субклиента должно присутствовать.",
                valueDisallowTransfer,equalTo(1));
        log.info("Выключаем право переноса средств у субклиента.");
        api.userSteps.clientFakeSteps().disableDisallowMoneyTransfer(ClientLogins.SUBCLIENT_WITH_REP2);
        log.info("Проверяем, что выключилось и у представителя.");
        valueDisallowTransfer =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.FIRST_REP2_SUBCLIENT,new String[]{DISALLOW_MONEY_TRANSFER}
                ).getDisallowMoneyTransfer();
        assertThat("право переноса средств выключено.", valueDisallowTransfer, equalTo(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5813")
    public void setDisallowTransferMoneyNoForRepAndCheckForAnotherRep(){
        assumeThat("право переноса средств у субклиента должно присутствовать.",
                valueDisallowTransfer,equalTo(1));
        log.info("Выключаем право переноса средств у субклиента.");
        api.userSteps.clientFakeSteps().disableDisallowMoneyTransfer(ClientLogins.SECOND_REP2_SUBCLIENT);
        log.info("Проверяем, что выключилось и у представителя.");
        valueDisallowTransfer =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.FIRST_REP2_SUBCLIENT,new String[]{DISALLOW_MONEY_TRANSFER}
                ).getDisallowMoneyTransfer();
        assertThat("право переноса средств выключено.", valueDisallowTransfer, equalTo(0));
    }
}
