package ru.yandex.autotests.directapi.clients.rights;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 03.12.14.
 */
@Aqua.Test
@Features(ClientFeatures.PING_API)
@Description("Доступ к АПИ привязан к ClientID: для представителя и клиента должен быть одинаковым. " +
        "По мотивам DIRECT-36816")
public class EnableApiForClientAndRepClientTest {
    private static LogSteps log = LogSteps.getLogger(EnableApiForClientAndRepClientTest.class);


    private static final String API_ENABLED = "api_enabled";
    private static String valueApiEnabled;
    private String apiEnabled;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    @Step("Подготовка данных для теста")
    public void prepareClient(){
        api.userSteps.clientFakeSteps().disableAPI(ClientLogins.CLIENT_WITH_REP1);
        valueApiEnabled =
                api.userSteps.clientFakeSteps().getClientData(ClientLogins.CLIENT_WITH_REP1,new String[]{API_ENABLED}).getAPIEnabled();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5816")
    public void setApiEnabledYesForClient(){
        assumeThat("доступ у клиента должен отсутствовать", valueApiEnabled,equalTo(Value.NO));
        log.info("Включаем доступ к АПИ у клиента.");
        api.userSteps.clientFakeSteps().enableAPI(ClientLogins.CLIENT_WITH_REP1);
        log.info("Проверяем, что галка изменилась.");
        apiEnabled = api.userSteps.clientFakeSteps().getClientData(ClientLogins.CLIENT_WITH_REP1,new String[]{API_ENABLED}).getAPIEnabled();
        assertThat("доступ к АПИ у клиента включён.", apiEnabled, equalTo(Value.YES));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5814")
    public void setApiEnabledYesForRepClient(){
        assumeThat("доступ у клиента должен отсутствовать", valueApiEnabled,equalTo(Value.NO));
        log.info("Включаем доступ к АПИ у клиента.");
        api.userSteps.clientFakeSteps().enableAPI(ClientLogins.CLIENT_WITH_REP1);
        log.info("Проверяем, что включился и у представителя.");
        apiEnabled =
                api.userSteps.clientFakeSteps().getClientData(ClientLogins.REP1_CLIENT,new String[]{API_ENABLED}).getAPIEnabled();
        assertThat("доступ к АПИ у представителя клиента включён.", apiEnabled, equalTo(Value.YES));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5815")
    public void checkApiAccessForRepClient(){
        assumeThat("доступ у клиента должен отсутствовать", valueApiEnabled,equalTo(Value.NO));
        log.info("Включаем доступ к АПИ у клиента.");
        api.userSteps.clientFakeSteps().enableAPI(ClientLogins.CLIENT_WITH_REP1);
        log.info("Проверяем, что включился и у представителя.");
        assertThat("доступ к АПИ у представителя появился.",
                api.as(ClientLogins.REP1_CLIENT).userSteps.pingAPISteps().pingAPI(), equalTo(1));
    }

}
