package ru.yandex.autotests.directapi.clients.rights;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 04.12.14.
 */
@Aqua.Test
@Features(ClientFeatures.SUBCLIENT_RIGHTS)
@Description("Проверка выставления галки \"право создания кампаний...\" для субклиента и его представителей." +
        "По мотивам DIRECT-35485")
public class EnableCreateCampaignForSubclientAndRepTest {
    private static LogSteps log = LogSteps.getLogger(EnableCreateCampaignForSubclientAndRepTest.class);
    private static final String ALLOW_CREATE_CAMPAIGNS = "allow_create_scamp_by_subclient";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private String valueAllowCreateCamp;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareSubClient(){
        api.userSteps.clientFakeSteps().disableToCreateSelfCampaigns(ClientLogins.SUBCLIENT_WITH_REP1);
        valueAllowCreateCamp =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.SUBCLIENT_WITH_REP1,new String[]{ALLOW_CREATE_CAMPAIGNS}
                ).getAllowCreateScampBySubclient();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5819")
    public void setAllowCreateCampYesForSubClient(){
        assumeThat("право создавать кампании у субклиента должно отсутствовать.",
                valueAllowCreateCamp,equalTo("0"));
        log.info("Включаем право создавать кампании у субклиента.");
        api.userSteps.clientFakeSteps().enableToCreateSelfCampaigns(ClientLogins.SUBCLIENT_WITH_REP1);
        log.info("Проверяем, что галка изменилась.");
        valueAllowCreateCamp =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.SUBCLIENT_WITH_REP1,new String[]{ALLOW_CREATE_CAMPAIGNS}
                ).getAllowCreateScampBySubclient();
        assertThat("право создавать кампании включено.", valueAllowCreateCamp, equalTo("1"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5817")
    public void setAllowCreateCampYesForSubClientAndCheckForRep(){
        assumeThat("право создавать кампании у субклиента должно отсутствовать.",
                valueAllowCreateCamp,equalTo("0"));
        log.info("Включаем право создавать кампании у субклиента.");
        api.userSteps.clientFakeSteps().enableToCreateSelfCampaigns(ClientLogins.SUBCLIENT_WITH_REP1);
        log.info("Проверяем, что включилось и у представителя.");
        valueAllowCreateCamp =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.FIRST_REP1_SUBCLIENT,new String[]{ALLOW_CREATE_CAMPAIGNS}
                ).getAllowCreateScampBySubclient();
        assertThat("право создавать кампании включено.", valueAllowCreateCamp, equalTo("1"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5818")
    public void setAllowCreateCampNoYesRepAndCheckForAnotherRep(){
        assumeThat("право создавать кампании у субклиента должно отсутствовать.",
                valueAllowCreateCamp,equalTo("0"));
        log.info("Включаем право создавать кампании у субклиента.");
        api.userSteps.clientFakeSteps().enableToCreateSelfCampaigns(ClientLogins.SECOND_REP1_SUBCLIENT);
        log.info("Проверяем, что включилось и у представителя.");
        valueAllowCreateCamp =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.FIRST_REP1_SUBCLIENT,new String[]{ALLOW_CREATE_CAMPAIGNS}
                ).getAllowCreateScampBySubclient();
        assertThat("право создавать кампании включено.", valueAllowCreateCamp, equalTo("1"));
    }

}
