package ru.yandex.autotests.directapi.clients.rights;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 04.12.14.
 */
@Aqua.Test
@Features(ClientFeatures.SUBCLIENT_RIGHTS)
@Description("Проверка выставления галки \"перенос средств\" для субклиента и его представителей." +
        "По мотивам DIRECT-35485")
public class EnableTransferMoneyForSubclientAndRepTest {
    private static LogSteps log = LogSteps.getLogger(EnableTransferMoneyForSubclientAndRepTest.class);
    private static final String DISALLOW_MONEY_TRANSFER = "disallow_money_transfer";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private int valueDisallowTransfer;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareSubClient(){
        api.userSteps.clientFakeSteps().disableDisallowMoneyTransfer(ClientLogins.SUBCLIENT_WITH_REP1);
        valueDisallowTransfer =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.SUBCLIENT_WITH_REP1,new String[]{DISALLOW_MONEY_TRANSFER}
                ).getDisallowMoneyTransfer();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5823")
    public void setDisallowTransferMoneyYesForSubClient(){
        assumeThat("право переноса средств у субклиента должно отсутствовать.",
                valueDisallowTransfer,equalTo(0));
        log.info("Включаем право переноса средств у субклиента.");
        api.userSteps.clientFakeSteps().enableDisallowMoneyTransfer(ClientLogins.SUBCLIENT_WITH_REP1);
        log.info("Проверяем, что галка изменилась.");
        valueDisallowTransfer =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.SUBCLIENT_WITH_REP1,new String[]{DISALLOW_MONEY_TRANSFER}
                ).getDisallowMoneyTransfer();
        assertThat("право переноса средств включено.", valueDisallowTransfer, equalTo(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5824")
    public void setDisallowTransferMoneyYesForSubClientAndCheckForRep(){
        assumeThat("право переноса средств у субклиента должно отсутствовать.",
                valueDisallowTransfer,equalTo(0));
        log.info("Включаем право переноса средств у субклиента.");
        api.userSteps.clientFakeSteps().enableDisallowMoneyTransfer(ClientLogins.SUBCLIENT_WITH_REP1);
        log.info("Проверяем, что включилось и у представителя.");
        valueDisallowTransfer =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.FIRST_REP1_SUBCLIENT,new String[]{DISALLOW_MONEY_TRANSFER}
                ).getDisallowMoneyTransfer();
        assertThat("право переноса средств включено.", valueDisallowTransfer, equalTo(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5825")
    public void setDisallowTransferMoneyYesForRepAndCheckForAnotherRep(){
        assumeThat("право переноса средств у субклиента должно отсутствовать.",
                valueDisallowTransfer,equalTo(0));
        log.info("Включаем право переноса средств у субклиента.");
        api.userSteps.clientFakeSteps().enableDisallowMoneyTransfer(ClientLogins.SECOND_REP1_SUBCLIENT);
        log.info("Проверяем, что включилось и у представителя.");
        valueDisallowTransfer =
                api.userSteps.clientFakeSteps().getClientData(
                        ClientLogins.FIRST_REP1_SUBCLIENT,new String[]{DISALLOW_MONEY_TRANSFER}
                ).getDisallowMoneyTransfer();
        assertThat("право переноса средств включено.", valueDisallowTransfer, equalTo(1));
    }
}
