package ru.yandex.autotests.directapi.clients.search;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.common.api45mng.SearchClientsResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.SearchClientsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.CoreMatchers.*;
import static org.hamcrest.CoreMatchers.hasItem;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * User: pavryabov
 * Date: 10.12.12
 *
 * https://jira.yandex-team.ru/browse/DIRECT-18978
 */

@Aqua.Test
@Features(ClientFeatures.SEARCH_CLIENTS)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class SearchClientAgencyNameTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private String agencyName;

    @Parameterized.Parameters(name = "Login = {0}")
    public static Collection roleValues() {
        Object[][] roleValues = new Object[][]{
                {Logins.SUPER_LOGIN},
                {Logins.SUPPORT},
                {Logins.SUPER_READER},
                {Logins.MEDIA},
                {Logins.PLACER}
        };
        return Arrays.asList(roleValues);
    }

    @Parameterized.Parameter
    public String login;

    private static String agencyLogin = Logins.AGENCY_YE_DEFAULT;
    @Before
    public void getAgencyName(){
        ClientInfo client = api.as(Logins.SUPER_LOGIN).userSteps.clientSteps().getClientInfo(agencyLogin);
        agencyName = client.getAgencyName();
        assumeThat("у агентства указано AgencyName", agencyName, notNullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5826")
    public void shouldSeeAgencyNameInResponse() {
        log.info("Выполняем поиск по логину агентства: "+ agencyLogin);
        SearchClientsResponse result = api.as(login).userSteps.clientSteps().searchClients(
                (SearchClientsRequestMap) new SearchClientsRequestMap(api.type())
                        .put(SearchClientsRequestMap.LOGIN, agencyLogin)
        );
        List<String> logins = extract(result.getClients(), on(ClientInfo.class).getAgencyName());
        assertThat("Не получен логин для агентства",
                logins, hasItem(equalTo(agencyName)));
    }
}
