package ru.yandex.autotests.directapi.clients.search;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.SearchClientsResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.SearchClientsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by proxeter on 18.01.16.
 *
 * TESTIRT-8240: added field campaignID in SearchClients
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-49935")
@Features(ClientFeatures.SEARCH_CLIENTS)
public class SearchClientByCampaignIdNegativeTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class).as(Logins.SUPER_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private int campaignId;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8873")
    public void searchClientWithNotAvailableCampaignId() {
        campaignId = 1;

        SearchClientsResponse result = api.userSteps.clientSteps().searchClients(
                new SearchClientsRequestMap(api.type()).withCampaignID(campaignId)
        );

        assertThat("не найдено ни одного клиента", Arrays.asList(result.getClients()), hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8874")
    public void searchClientWithZeroCampaignId() {
        campaignId = 0;

        api.userSteps.clientSteps().shouldGetErrorOn(
                Method.SEARCH_CLIENTS,
                new SearchClientsRequestMap(api.type()).withCampaignID(campaignId),
                new AxisError(71, AxisErrorDetails.THE_CAMPAIGNID_SHOULD_BE_MORE_THAN_ZERO)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8875")
    public void searchClientWithNegativeCampaignId() {
        campaignId = -1;

        api.userSteps.clientSteps().shouldGetErrorOn(
                Method.SEARCH_CLIENTS,
                new SearchClientsRequestMap(api.type()).withCampaignID(campaignId),
                new AxisError(71, AxisErrorDetails.THE_CAMPAIGNID_FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE)

        );
    }

}
