package ru.yandex.autotests.directapi.clients.search;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.common.api45mng.SearchClientsResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.SearchClientsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by proxeter on 15.01.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8240
 */
@Aqua.Test
@Title("SearchClients: поиск по идентификатору кампании")
@Issue("https://st.yandex-team.ru/DIRECT-49935")
@Features(ClientFeatures.SEARCH_CLIENTS)
@RunWith(Parameterized.class)
public class SearchClientByCampaignIdTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String agencyLogin;

    @Parameterized.Parameter(1)
    public String clientLogin;

    private ClientInfo expectedClient;

    private Long campaignId;

    @Parameterized.Parameters(name = "agencyLogin = {0}, clientLogin = {1}")
    public static Collection data() {
        Object[][] data = new Object[][] {
                { null, Logins.CLIENT_SELF }, // Самостоятельный клиент
                { Logins.AGENCY_ANOTHER, Logins.CLIENT_AGENCY_ANOTHER }, // Клиент агенства
                { null, Logins.ACCOUNT_SERVICED_CLIENT_SHARD_2 }, // Сервисируемый клиент
                { null, Logins.INDEPENDENT_CLIENT_WITH_REPS } // Самостоятельный клиент с несколькими представителями
        };

        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void before() {
        String asLogin = (agencyLogin != null)? agencyLogin : clientLogin;

        campaignId = api.as(asLogin).userSteps.campaignStepsV5().addDefaultTextCampaign(clientLogin);
        expectedClient = api.as(Logins.SUPER_LOGIN).userSteps.clientSteps().getClientInfo(clientLogin);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8876")
    public void searchClientByCampaignId() {
        SearchClientsResponse result = api.userSteps.clientSteps().searchClients(
                new SearchClientsRequestMap(api.type()).withCampaignID(campaignId.intValue())
        );
        assumeThat("найден один клиент", Arrays.asList(result.getClients()), hasSize(1));

        ClientInfo actualClient = result.getClients()[0];

        assertThat("найден правильный клиент", actualClient, beanDiffer(expectedClient));
    }

}
