package ru.yandex.autotests.directapi.clients.search;

import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.SearchClientsResponse;
import ru.yandex.autotests.directapi.matchers.arrays.ArraySizeMatcher;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.SearchClientsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.steps.clients.ClientSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.having;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.CoreMatchers.allOf;

/**
 * User: pavryabov
 * Date: 10.12.12
 */

@Aqua.Test
@Features(ClientFeatures.SEARCH_CLIENTS)
public class SearchClientResponseLengthTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class).as(Logins.SUPER_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5827")
    public void checkMaxResponseSize() {
        log.info("Поиска клиента");
        SearchClientsRequestMap searchClientsRequestMap =
                (SearchClientsRequestMap) new SearchClientsRequestMap(api.type())
                        .put(SearchClientsRequestMap.NAME, "мар");

        log.info(JsonUtils.toString(searchClientsRequestMap.getBean()));
        log.info(
                String.format(
                        "Ожидаем, что поиск вернет %s клиентов, так как удовлетворяющих запросу еще больше"
                        , ClientSteps.SEARCH_CLIENTS_RESPONSE_MAX_ITEMS));

        SearchClientsResponse result = api.userSteps.clientSteps().searchClients(searchClientsRequestMap);
        log.info("Проверка результатов поиска");
        Assert.assertThat("Не получили 1000 клиентов в ответе",
                result,
                allOf(
                        having(on(SearchClientsResponse.class).getCount(), Matchers.greaterThan(1000)),
                        having(on(SearchClientsResponse.class).getClients(), ArraySizeMatcher.hasSize(1000))
                ));
        log.info("Результаты поиска верны");
    }
}
