package ru.yandex.autotests.directapi.clients.search;

import org.apache.commons.lang.StringUtils;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.SearchClientsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static ru.yandex.autotests.directapi.model.clients.SearchClientsRequestMap.*;

/**
 * User: mariabye
 * Date: 16.08.12
 */
@Aqua.Test(title = "SearchClients: недопустимые параметры запроса")
@Features(ClientFeatures.SEARCH_CLIENTS)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class SearchClientsNegativeRequestTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameters(name = "Login = {0}")
    public static Collection roleValues() {
        ClientInfo clientToVerify = api.userSteps.clientSteps()
                .getClientInfo(Logins.CLIENT_FREE_YE_DEFAULT);
        Object[][] roleValues = new Object[][]{
                {
                        new SearchClientsRequestMap(api.type()).put(LOGIN, ""),
                        new AxisError(251, AxisErrorDetails.INVALID_FIELD, StringUtils.capitalize(LOGIN))
                },
                {
                        new SearchClientsRequestMap(api.type()).put(USER_ID, -1),
                        new AxisError(71,
                                AxisErrorDetails.FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE,
                                StringUtils.capitalize(USER_ID))
                },
                {
                        new SearchClientsRequestMap(api.type()).put(USER_ID, 0),
                        new AxisError(71,
                                AxisErrorDetails.FIELD_VALUE_SHOULD_BE_MORE_THAN_0,
                                StringUtils.capitalize(USER_ID))
                },
                {
                        new SearchClientsRequestMap(api.type()).put(CLIENT_ID, -1),
                        new AxisError(71,
                                AxisErrorDetails.FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE,
                                StringUtils.capitalize(CLIENT_ID))
                },
                {
                        new SearchClientsRequestMap(api.type()).put(CLIENT_ID, 0),
                        new AxisError(71,
                                AxisErrorDetails.FIELD_VALUE_SHOULD_BE_MORE_THAN_0,
                                StringUtils.capitalize(CLIENT_ID))
                },
                {
                        new SearchClientsRequestMap(api.type()).put(LOGIN, "test&^$%^3login123432"),
                        new AxisError(251,
                                AxisErrorDetails.INVALID_FIELD,
                                StringUtils.capitalize(LOGIN))
                },
                {
                        new SearchClientsRequestMap(api.type()).put(LOGIN, " "),
                        new AxisError(251,
                                AxisErrorDetails.INVALID_FIELD,
                                StringUtils.capitalize(LOGIN))
                },
                {
                        null,
                        new AxisError(71,
                                AxisErrorDetails.SEARCH_CLIENT_REQUEST_FILTER_COULD_NOT_BE_EMPTY)
                },
                {
                        new SearchClientsRequestMap(api.type()),
                        new AxisError(71,
                                AxisErrorDetails.SEARCH_CLIENT_REQUEST_FILTER_COULD_NOT_BE_EMPTY)
                },
                {
                        new SearchClientsRequestMap(api.type())
                                .withLogin(clientToVerify.getLogin())
                                .withUserID(0),
                        new AxisError(71,
                                AxisErrorDetails.FIELD_VALUE_SHOULD_BE_MORE_THAN_0,
                                StringUtils.capitalize(USER_ID))
                },
                {
                        new SearchClientsRequestMap(api.type())
                                .withLogin(clientToVerify.getLogin())
                                .withClientID(0),
                        new AxisError(71,
                                AxisErrorDetails.FIELD_VALUE_SHOULD_BE_MORE_THAN_0,
                                StringUtils.capitalize(CLIENT_ID))
                },
        };
        return Arrays.asList(roleValues);
    }

    @Parameterized.Parameter(value = 0)
    public SearchClientsRequestMap searchClientsRequestMap;

    @Parameterized.Parameter(value = 1)
    public AxisError axisError;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5829")
    public void callSearchClientsWithInvalidRequest() {
        api.userSteps.clientSteps().shouldGetErrorOn(
                Method.SEARCH_CLIENTS,
                searchClientsRequestMap,
                axisError);
    }
}

