package ru.yandex.autotests.directapi.clients.search;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.SearchClientsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * User: mariabye
 * Date: 16.08.12
 */
@Aqua.Test(title = "SearchClients: agency, manager, client")
@RunWith(Parameterized.class)
@Features(ClientFeatures.SEARCH_CLIENTS)
@Tag(TagDictionary.TRUNK)
public class SearchClientsRoleBlockedAccessTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());


    public static final String CLIENT = Logins.CLIENT_FREE_YE_DEFAULT;
    public static final String SELF_CLIENT = Logins.CLIENT_SELF;
    public static final String AGENCY = Logins.AGENCY_YE_DEFAULT;
    public static final String MANAGER = Logins.MANAGER_DEFAULT;
    public static final String SUPER = Logins.SUPER_LOGIN;
    public static final String SUPPORT = Logins.SUPPORT;
    public static final String PLACER = Logins.PLACER;
    public static final String SUPER_READER = Logins.SUPER_READER;
    public static final String MEDIA = Logins.MEDIA;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class).as(SUPER);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameters(name = "Operator = {0}, Login to search= {1}")
    public static Collection searchEnvironment() {
        List<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{AGENCY, CLIENT});
        data.add(new Object[]{AGENCY, AGENCY});
        data.add(new Object[]{AGENCY, MANAGER});
        data.add(new Object[]{AGENCY, SUPER});
        data.add(new Object[]{AGENCY, SUPPORT});
        data.add(new Object[]{AGENCY, PLACER});
        data.add(new Object[]{AGENCY, SUPER_READER});
        data.add(new Object[]{AGENCY, MEDIA});
        data.add(new Object[]{AGENCY, SELF_CLIENT});

        data.add(new Object[]{MANAGER, CLIENT});
        data.add(new Object[]{MANAGER, AGENCY});
        data.add(new Object[]{MANAGER, MANAGER});
        data.add(new Object[]{MANAGER, SUPER});
        data.add(new Object[]{MANAGER, PLACER});
        data.add(new Object[]{MANAGER, SUPER_READER});
        data.add(new Object[]{MANAGER, MEDIA});
        data.add(new Object[]{MANAGER, SELF_CLIENT});

        data.add(new Object[]{CLIENT, CLIENT});
        data.add(new Object[]{CLIENT, AGENCY});
        data.add(new Object[]{CLIENT, MANAGER});
        data.add(new Object[]{CLIENT, SUPER});
        data.add(new Object[]{CLIENT, PLACER});
        data.add(new Object[]{CLIENT, SUPER_READER});
        data.add(new Object[]{CLIENT, MEDIA});
        data.add(new Object[]{CLIENT, SELF_CLIENT});
        return data;
    }

    @Parameterized.Parameter
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String loginToSearch;


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5831")
    public void callSearchClientsWithOnlyValidLogin() {
        log.info(String.format("Поиск клиента по Login(=%s) под ролью %s", loginToSearch, operator));
        SearchClientsRequestMap searchClientsRequestMap = new SearchClientsRequestMap(api.type())
                .withLogin(loginToSearch);
        api.as(operator).userSteps.clientSteps().shouldGetErrorOn(
                Method.SEARCH_CLIENTS,
                searchClientsRequestMap,
                new AxisError(54, AxisErrorDetails.EMPTY_STRING)
        );
    }
}

