package ru.yandex.autotests.directapi.clients.search.internalroles;

import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.common.api45mng.SearchClientsResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.SearchClientsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.CoreMatchers.hasItem;

/**
 * User: mariabye
 * Date: 16.08.12
 */
@Aqua.Test(title = "SearchClients: параметры запроса")
@RunWith(Parameterized.class)
@Tag(TagDictionary.TRUNK)
@Features(ClientFeatures.SEARCH_CLIENTS)
@Title("Поиск клиентов под ролью супер-смотрящего")
public class SearchClientsBySuperReaderTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());


    public static final String CLIENT = Logins.CLIENT_FREE_YE_DEFAULT;
    public static final String AGENCY = Logins.AGENCY_YE_DEFAULT;
    public static final String MANAGER = Logins.MANAGER_DEFAULT;
    public static final String SUPER = Logins.SUPER_LOGIN;
    public static final String SUPPORT = Logins.SUPPORT;
    public static final String PLACER = Logins.PLACER;
    public static final String SUPER_READER = Logins.SUPER_READER;
    public static final String MEDIA = Logins.MEDIA;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class).as(SUPER_READER);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameters(name = "login to search = {0}")
    public static Collection searchEnvironment() {
        List<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{CLIENT});
        data.add(new Object[]{AGENCY});
        data.add(new Object[]{MANAGER});
        data.add(new Object[]{SUPER});
        data.add(new Object[]{SUPPORT});
        data.add(new Object[]{PLACER});
        data.add(new Object[]{SUPER_READER});
        data.add(new Object[]{MEDIA});

        return data;
    }

    @Parameterized.Parameter
    public String loginToSearch;


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5835")
    public void callSearchClientsWithOnlyValidLogin() {
        SearchClientsRequestMap searchClientsRequestMap =
                (SearchClientsRequestMap) new SearchClientsRequestMap(api.type())
                .put(SearchClientsRequestMap.LOGIN, loginToSearch);
        SearchClientsResponse searchResponse = api.userSteps.clientSteps().searchClients(searchClientsRequestMap);
        log.info("Проверка результатов поиска");
        List<String> logins = extract(searchResponse.getClients(), on(ClientInfo.class).getLogin());
        TestSteps.assertThat("получен клиент, удовлетворяющий запросу поиска",
                logins, hasItem(Matchers.equalTo(loginToSearch)));
    }
}

