package ru.yandex.autotests.directapi.clients.smoke;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Author pavryabov
 * Date 09.04.14
 */
@Aqua.Test
@Features(ClientFeatures.CLIENT_MONITOR)
@Stories(ClientFeatures.PASWORDS)
@RunWith(Parameterized.class)
public class CheckPasswordsSmokeTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @Parameterized.Parameter(0)
    public String login;

    @Parameterized.Parameters(name = "Login = {0}")
    public static Collection roleValues() {
        return Arrays.asList(new Object[][]{
                {"at-direct-super"},
                {"at-direct-mngr-full"},
                {"at-direct-web-superreader"},
                {"at-direct-transfer-mngr"},
                {"at-direct-support"}
        });
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5839")
    public void checkPassword() {
        api.as(login).userSteps.getVersionsSteps().getAvailableVersions();
    }
}
