package ru.yandex.autotests.directapi.clients.smoke;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45.ClientsUnitInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.terra.junit.rules.BottleMessageRule;

/**
 * Author pavryabov
 * Date 10.04.14
 */
@Aqua.Test
@Features(ClientFeatures.CLIENT_MONITOR)
@Stories(ClientFeatures.UNITS)
public class CheckUnitsForAPIClientSmokeTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = Logins.CLIENT_FREE_YE_DEFAULT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5840")
    public void createCampaignTimeTest() {
        int units = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        if (units < 100000) {
            api.userSteps.clientFakeSteps().setAPIUnits(login, 12000000);
        }
    }
}
