package ru.yandex.autotests.directapi.clients.updateclientinfo;

import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.model.clients.ClientRightMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;


/**
 * Created by chicos on 23.06.14.
 * <p/>
 * https://jira.yandex-team.ru/browse/TESTIRT-2060
 */
@Aqua.Test
@Features(ClientFeatures.UPDATE_CLIENT_INFO)
public class UpdateClientInfoAgencyTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String agencyLogin = ClientLogins.AGENCY_FOR_UPDATES;
    private static final String subClientLogin = ClientLogins.SUBCLIENT_FOR_UPDATES;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(agencyLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @Title("Агентство может поменять данные о своем суб-клиенте")
    @ru.yandex.qatools.allure.annotations.TestCaseId("5841")
    public void updateAllFieldsSubClientByAgencyTest() {
        ClientInfo clientInfoBefore = api.userSteps.clientSteps().getClientInfo(subClientLogin);
        ClientInfoMap clientMap = nextClientInfo(clientInfoBefore)
                .withLogin(subClientLogin)
                .withClientRights(
                        new ClientRightMap(api.type())
                                .allowEditCampaign(Value.NO),
                        new ClientRightMap(api.type())
                                .allowImportXls(Value.NO),
                        new ClientRightMap(api.type())
                                .allowTransferMoney(Value.YES)
                );
        api.userSteps.clientSteps().updateClientInfo(clientMap);
        ClientInfo clientInfoAfter = api.userSteps.clientSteps().getClientInfo(subClientLogin);

        assertThat("Некорректные данные после обновления профиля", clientInfoAfter,
                BeanEquals.beanEquals(clientMap.getBean()));
    }

    @Test
    @Title("Агентство может поменять данные о себе")
    @ru.yandex.qatools.allure.annotations.TestCaseId("5842")
    public void updateAllFieldsAgencyItselfTest() {
        ClientInfo agencyInfoBefore = api.userSteps.clientSteps().getClientInfo(agencyLogin);
        ClientInfoMap clientMap = nextAgencyInfo(agencyInfoBefore)
                .withLogin(agencyLogin)
                .withSendNews(Value.NO);
        api.userSteps.clientSteps().updateClientInfo(clientMap);
        ClientInfo agencyInfoAfter = api.userSteps.clientSteps().getClientInfo(agencyLogin);

        //send options expected to be always ON for agency
        clientMap.withSendAccNews(Value.YES)
                .withSendNews(Value.YES)
                .withSendWarn(Value.YES);
        assertThat("Некорректные данные после обновления профиля", agencyInfoAfter,
                BeanEquals.beanEquals(clientMap.getBean()));
    }

    @Test
    @Title("Агентство можнт поменять данные о клиенте, не меняя его прав")
    @ru.yandex.qatools.allure.annotations.TestCaseId("5843")
    public void updateInfoClientRightsNotChangedTest() {
        ClientInfo clientInfoBefore = api.userSteps.clientSteps().getClientInfo(subClientLogin);
        ClientInfoMap clientMap = nextClientInfo(clientInfoBefore)
                .withLogin(subClientLogin);
        api.userSteps.clientSteps().updateClientInfo(clientMap);
        ClientInfo clientInfoAfter = api.userSteps.clientSteps().getClientInfo(subClientLogin);

        assertThat("Некорректные данные после обновления профиля", clientInfoAfter,
                BeanEquals.beanEquals(clientMap.getBean()));
    }

    private ClientInfoMap nextClientInfo(ClientInfo info) {
        return (info.getPhone() != null && info.getPhone().equals(ClientInfoMap.DEFAULT_PHONE))
                ? (new ClientInfoMap(info).anotherClientInfo())
                : (new ClientInfoMap(info).defaultClientInfo());
    }

    private ClientInfoMap nextAgencyInfo(ClientInfo info) {
        return (info.getPhone() != null && info.getPhone().equals(ClientInfoMap.DEFAULT_PHONE))
                ? (new ClientInfoMap(api.type()).anotherAgencyInfo())
                : (new ClientInfoMap(api.type()).defaultAgencyInfo());
    }
}
