package ru.yandex.autotests.directapi.clients.updateclientinfo;

import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;


/**
 * Created by chicos on 23.06.14.
 *
 * https://jira.yandex-team.ru/browse/TESTIRT-2060
 */
@Aqua.Test
@Features(ClientFeatures.UPDATE_CLIENT_INFO)
@Tag(TagDictionary.TRUNK)
public class UpdateClientInfoClientTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String clientLogin = ClientLogins.LONELY_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(clientLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5844")
    public void updateAllFieldsTest() {
        ClientInfo clientInfoBefore = api.userSteps.clientSteps().getClientInfo(clientLogin);
        ClientInfoMap clientMap = nextClientInfo(clientInfoBefore).withLogin(clientLogin);
        api.userSteps.clientSteps().updateClientInfo(clientMap);
        ClientInfo clientInfoAfter = api.userSteps.clientSteps().getClientInfo(clientLogin);

        assertThat("Некорректные данные после обновления профиля", clientInfoAfter,
                BeanEquals.beanEquals(clientMap.getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5845")
    public void updateReadonlyFieldsTest() {
        ClientInfo clientInfoBefore = api.userSteps.clientSteps().getClientInfo(clientLogin);
        ClientInfoMap clientMap = new ClientInfoMap<>((ClientInfo)api.userSteps.clientSteps().getClientInfo(clientLogin))
                .withLogin(clientLogin)
                .withCurrency(Currency.UAH.value())
                .withVATRate(87.0f);
        api.userSteps.clientSteps().updateClientInfo(clientMap);
        ClientInfo clientInfoAfter = api.userSteps.clientSteps().getClientInfo(clientLogin);

        assertThat("Некорректные данные после обновления профиля", clientInfoAfter,
                BeanEquals.beanEquals(clientInfoBefore));
    }

    private ClientInfoMap nextClientInfo(ClientInfo info){
        return (info.getPhone() != null && info.getPhone().equals(ClientInfoMap.DEFAULT_PHONE))
                ? (new ClientInfoMap(api.type()).anotherClientInfo())
                : (new ClientInfoMap(api.type()).defaultClientInfo());
    }
}
