package ru.yandex.autotests.directapi.clients.updateclientinfo;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;

/**
 * Author pavryabov
 * Date 20.06.14
 * https://jira.yandex-team.ru/browse/TESTIRT-364
 */
@Aqua.Test
@Features(ClientFeatures.UPDATE_CLIENT_INFO)
@Tag(TagDictionary.TRUNK)
@Stories(ApiStories.CURRENCY)
@RunWith(Parameterized.class)
public class UpdateClientInfoCurrencyTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(Logins.LOGIN_FOR_RUB);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String currency;

    @Parameterized.Parameter(1)
    public String[] clientCurrencies;

    @Parameterized.Parameter(2)
    public Float vatRate;

    @Parameterized.Parameters(name = "Currency = {0}, VATRate = {2}")
    public static Collection newValues() {
        Object[][] data = new Object[][]{
                {Currency.RUB.toString(), new String[]{Currency.USD.toString()}, 0.0f},
                {"rub", new String[]{"rub"}, -5f}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5846")
    public void updateClientInfo() {
        api.as(Logins.LOGIN_FOR_RUB);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(Logins.LOGIN_FOR_RUB);
        api.userSteps.clientSteps().updateClientInfo(
                new ClientInfoMap(clientInfo)
                        .withCurrency(currency)
                        .withClientCurrencies(clientCurrencies)
                        .withVATRate(vatRate)
        );
        clientInfo = api.userSteps.clientSteps().getClientInfo(Logins.LOGIN_FOR_RUB);
        BeanCompareStrategy strategy = new BeanCompareStrategy();
        strategy.putFieldMatcher((ClientInfoMap.CURRENCY), nullValue());
        strategy.putFieldMatcher((ClientInfoMap.CLIENT_CURRENCIES), equalTo(new String[]{Currency.RUB.toString()}));
        assertThat(clientInfo,
                beanEquals(new ClientInfoMap(api.type())
                        .withVATRate((float) MoneyCurrency.get(Currency.RUB).getVatRate() * 100).getBean())
                        .accordingStrategy(strategy));
    }
}
