package ru.yandex.autotests.directapi.clients.updateclientinfo;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static com.sun.xml.ws.util.StringUtils.capitalize;

/**
 * Author pavryabov
 * Date 22.09.14
 * https://st.yandex-team.ru/TESTIRT-2829
 */
@Aqua.Test
@Features(ClientFeatures.UPDATE_CLIENT_INFO)
@RunWith(Parameterized.class)
public class UpdateClientInfoEmailNegativeTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(Logins.MANAGER_GEO).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String email;

    @Parameterized.Parameter(value = 1)
    public AxisError expectedError;

    @Parameterized.Parameters(name = "Email = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"at-tester@yandex.r",
                        new AxisError(34, AxisErrorDetails.INVALID_FIELD, capitalize(ClientInfoMap.EMAIL))},
                {"at-tester@yandex.rurururururururu",
                        new AxisError(34, AxisErrorDetails.INVALID_FIELD, capitalize(ClientInfoMap.EMAIL))},
                {"at-tester@яндекс.а",
                        new AxisError(34, AxisErrorDetails.INVALID_FIELD, capitalize(ClientInfoMap.EMAIL))},
                {"at-tester@яндекс.абвгдежзиклмнопр",
                        new AxisError(34, AxisErrorDetails.INVALID_FIELD, capitalize(ClientInfoMap.EMAIL))},
                {"at-tester@123.45",
                        new AxisError(34, AxisErrorDetails.INVALID_FIELD, capitalize(ClientInfoMap.EMAIL))}
        };
        return Arrays.asList(data);
    }

    public static String client;

    @BeforeClass
    public static void createClient() {
        CreateNewSubclientResponse createNewSubclientResponse =
                api.userSteps.clientSteps().createServicedClient("subClient", ClientLogins.MANAGER_GEO);
        client = createNewSubclientResponse.getLogin();
        api.userSteps.clientFakeSteps().enableAPI(client);
        api.as(Logins.SUPER_LOGIN, client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5851")
    public void updateClientInfoWithInvalidEmail() {
        api.userSteps.clientSteps().shouldGetErrorOn(Method.UPDATE_CLIENT_INFO,
                new ClientInfo[]{
                        (ClientInfo)new ClientInfoMap(api.type())
                                .defaultClientInfo().withLogin(client).withEmail(email).getBean()},
                expectedError);
    }
}
