package ru.yandex.autotests.directapi.clients.updateclientinfo;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * Author pavryabov
 * Date 22.09.14
 * https://st.yandex-team.ru/TESTIRT-2829
 */
@Aqua.Test
@Features(ClientFeatures.UPDATE_CLIENT_INFO)
@RunWith(Parameterized.class)
public class UpdateClientInfoEmailTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(Logins.MANAGER_GEO).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String email;

    @Parameterized.Parameter(value = 1)
    public String expectedEmail;

    @Parameterized.Parameters(name = "Email = {0}, ExpectedEmail = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"at-tester@yandex.ru", "at-tester@yandex.ru"},
                {"at-tester@yandex.rururururururur", "at-tester@yandex.rururururururur"},
                {"at-tester@яндекс.аб", "at-tester@яндекс.аб"},
                {"at-tester@яндекс.абвгдежзиклмноп", "at-tester@яндекс.абвгдежзиклмноп"},
                {"at-tester@123.a45", "at-tester@123.a45"},
                {"at-tester@сувеніри.укр", "at-tester@сувеніри.укр"}
        };
        return Arrays.asList(data);
    }

    public static String client;

    @BeforeClass
    public static void createClient() {
        CreateNewSubclientResponse createNewSubclientResponse =
                api.userSteps.clientSteps().createServicedClient("subClient", ClientLogins.MANAGER_GEO);
        client = createNewSubclientResponse.getLogin();
        api.userSteps.clientFakeSteps().enableAPI(client);
        api.as(Logins.SUPER_LOGIN, client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5852")
    public void updateAndCheckEmail() {
        api.userSteps.clientSteps().updateClientInfo(
                new ClientInfoMap(api.type()).defaultClientInfo().withLogin(client).withEmail(email));
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client);
        assertThat("Email сохранился неправильно",
                clientInfo.getEmail(), equalTo(expectedEmail));
    }
}
