package ru.yandex.autotests.directapi.clients.updateclientinfo;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ClientsOptionsRecord;
import ru.yandex.autotests.direct.db.steps.ClientsOptionsSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.utils.matchers.BeanEqualsAssert.assertThat;


/**
 * Created by ginger on 09.04.16.
 * https://st.yandex-team.ru/TESTIRT-8931
 */
@Aqua.Test
@Features(ClientFeatures.UPDATE_CLIENT_INFO)
@Description("Проверяем, что не затирается флаг no_display_hrefs")
@Issue("https://st.yandex-team.ru/DIRECT-52434")
public class UpdateClientInfoNoDisplayHrefsTest {
    private static long clientID;
    public static String FLAG = ClientsOptionsSteps.ClientFlagsEnum.NO_DISPLAY_HREFS.toString();
    private static final String CLIENT = ClientLogins.LONELY_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    public static ClientInfo clientInfo;

    @BeforeClass
    public static void initClient(){
        api.as(Logins.SUPER_LOGIN);
        clientID = Integer.parseInt(api.userSteps.getDarkSideSteps().getClientFakeSteps().getClientData(CLIENT).getClientID());
        clientInfo =  api.userSteps.clientSteps().getClientInfo(CLIENT);
    }

    @Test
    public void updateClientInfoAndCkeckFlag(){
        ClientsOptionsRecord clientOptions = api.userSteps.getDirectJooqDbSteps().useShardForClientId(clientID)
                .clientsOptionsSteps()
                .getClientOptions(clientID);
        clientOptions.setClientFlags(FLAG);
        api.userSteps.getDirectJooqDbSteps().clientsOptionsSteps().updateClientOptions(clientOptions);
        api.userSteps.clientSteps().updateClientInfo(
                new ClientInfoMap(clientInfo)
                        .withPhone(RandomStringUtils.randomNumeric(3))
        );
        clientOptions = api.userSteps.getDirectJooqDbSteps().clientsOptionsSteps().getClientOptions(clientID);
        assertThat("no_display_href флаг не затерся",clientOptions.getClientFlags(), equalTo(FLAG));
    }
}
