package ru.yandex.autotests.directapi.clients.updateclientinfo;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;


/**
 * Created by chicos on 23.06.14.
 *
 * https://jira.yandex-team.ru/browse/TESTIRT-2060
 */
@Aqua.Test
@Features(ClientFeatures.UPDATE_CLIENT_INFO)
@RunWith(Parameterized.class)
public class UpdateClientInfoRolesAccessTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String singleClientLogin = ClientLogins.LONELY_CLIENT;

    private static final String managerLogin = Logins.MANAGER_DEFAULT;
    private static final String agencyLogin = Logins.AGENCY_YE_DEFAULT;
    private static final String subClientLogin = Logins.CLIENT_FREE_YE_DEFAULT;
    private static final String servClientLogin = Logins.CLIENT_SERV_YE_DEFAULT;
    private static final String superReader = Logins.SUPER_READER;


    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String fellowToBeUpdated;

    @Parameterized.Parameters(name = "operator = {0}, target = {1}")
    public static Collection statuses(){
        Object[][] data = new Object[][]{
                {singleClientLogin, agencyLogin},
                {agencyLogin, managerLogin},
                {subClientLogin, agencyLogin},
                {superReader, singleClientLogin},
                {superReader, agencyLogin},
                {servClientLogin, managerLogin}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5853")
    public void updateClientInfoNoRightsTest()  {
        api.as(operator).userSteps.shouldGetErrorOn(Method.UPDATE_CLIENT_INFO,
                new ClientInfo[]{(ClientInfo) new ClientInfoMap<>(api.type())
                        .defaultAgencyInfo()
                        .withLogin(fellowToBeUpdated)
                        .withFIO("Это не должно было случиться")
                        .getBean()},
                new AxisError(251, AxisErrorDetails.EMPTY_STRING)
        );
    }
}
