package ru.yandex.autotests.directapi.clients.updateclientinfo;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by ginger on 13.01.14.
 *
 * https://jira.yandex-team.ru/browse/DIRECT-27463
 */
@Aqua.Test
@Features(ClientFeatures.UPDATE_CLIENT_INFO)
@RunWith(Parameterized.class)
public class UpdateClientInfoShardingNegativeTest {
    protected Logger log = LogManager.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String client;

    private ClientInfo clientInfo;

    @Parameterized.Parameters(name = "Operator = {0}, Client = {1}")
    public static Collection roles() {
        Object[][] data = new Object[][]{
                {Logins.AGENCY_IN_2_SHARD, Logins.CLIENT_IN_2_SHARD},
                {Logins.AGENCY_YE_DEFAULT, Logins.SERVICED_CLIENT_IN_2_SHARD},
                {Logins.MANAGER_DEFAULT, Logins.CLIENT_IN_2_SHARD},
                //https://jira.yandex-team.ru/browse/DIRECT-28050
                {Logins.SUPER_READER, Logins.CLIENT_FREE_YE_DEFAULT},
                {Logins.SUPER_READER, Logins.CLIENT_IN_2_SHARD},
                {Logins.SUPER_READER, Logins.SUBCLIENT_IN_2_SHARD},
                {Logins.SUPER_READER, Logins.SERVICED_CLIENT_IN_2_SHARD},
                {Logins.PLACER, Logins.CLIENT_IN_2_SHARD},
                {Logins.PLACER, Logins.SERVICED_CLIENT_IN_2_SHARD}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest(){
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.CLIENT_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SUBCLIENT_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SERVICED_CLIENT_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    public void initClient(){
        api.as(Logins.SUPER_LOGIN,client);
        clientInfo = api.userSteps.clientSteps().getClientInfo(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5854")
    public void tryUpdateClientInfoShouldBeError(){
        api.as(operator);
        clientInfo.setPhone("123");
        api.userSteps.shouldGetErrorOn(Method.UPDATE_CLIENT_INFO,
                new ClientInfo[]{clientInfo},
                new AxisError(251, AxisErrorDetails.EMPTY_STRING));
    }
}
