package ru.yandex.autotests.directapi.clients.updateclientinfo.agency;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created by chicos on 20.06.14.
 *
 * https://jira.yandex-team.ru/browse/TESTIRT-2060
 */
@Aqua.Test
@Features(ClientFeatures.UPDATE_CLIENT_INFO)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateClientInfoAgencyNameTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String managerLogin = Logins.MANAGER_DEFAULT;
    private static final String agencyLogin = ClientLogins.AGENCY_ANOTHER_1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(managerLogin).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String agencyName;

    @Parameterized.Parameters(name = "name = {0}")
    public static Collection names(){
        Object[][] data = new Object[][]{
                {"Автотестовое агентство"},
                {"   Автотестовое агентство  "},
                {"undef"},
                {"\"null\""},
                {" "},
                {"-$#%$(#*%($@#)$дываодываdfuasiodfuiosdf\""},
                {RandomStringUtils.randomAlphabetic(255)},
                {"\"\""},
                {"\"   \""},
                {null}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5856")
    public void updateAgencyNameByManagerTest() {
        ClientInfoMap agencyMap = new ClientInfoMap<>((ClientInfo)api.userSteps.clientSteps().getClientInfo(agencyLogin));
        agencyMap.withAgencyName(agencyName);
        api.userSteps.clientSteps().updateClientInfo(agencyMap);
        ClientInfo agencyInfo = api.userSteps.clientSteps().getClientInfo(agencyLogin);

        agencyMap.withAgencyName(
                (agencyName != null) ? (agencyName.trim()) : (null)
        );
        assertThat("Некорректные данные после обновления AgencyName", agencyInfo,
                BeanEquals.beanEquals(agencyMap.getBean()));
    }
}
