package ru.yandex.autotests.directapi.clients.updateclientinfo.agency;

import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;


/**
 * Created by chicos on 19.06.14.
 *
 * https://jira.yandex-team.ru/browse/TESTIRT-2060
 */
@Aqua.Test
@Features(ClientFeatures.UPDATE_CLIENT_INFO)
public class UpdateClientInfoAllAgencyFieldsTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String managerLogin = Logins.MANAGER_DEFAULT;
    private static final String agencyLogin = ClientLogins.AGENCY2_FOR_UPDATES;
    private static final String clientLogin = ClientLogins.SUBCLIENT2_FOR_UPDATES;
    private static final String clientLoginServ = ClientLogins.SERVICED_CLIENT_FOR_UPDATES;

    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5859")
    public void updateAgencyFieldsForAgencyByManagerTest() {
        api.as(managerLogin);
        ClientInfo clientInfoBefore = api.userSteps.clientSteps().getClientInfo(agencyLogin);
        ClientInfoMap clientMap = new ClientInfoMap<>(clientInfoBefore);
        clientMap.withAgencyName(
                (clientInfoBefore.getAgencyName() != null && clientInfoBefore.getAgencyName().equals("Тестовое агентство автотестера"))
                        ? ("Incredible Agency Name")
                        : ("Тестовое агентство автотестера"));
        clientMap.withAgencyStatus(
                (clientInfoBefore.getAgencyStatus() != null && clientInfoBefore.getAgencyStatus().equals("AA"))
                        ? ("SA")
                        : ("AA"));
        clientMap.withAgencyUrl(
                (clientInfoBefore.getAgencyUrl() != null && clientInfoBefore.getAgencyUrl().equals("test.yandex.ru"))
                        ? ("agency.url.yandex.ru")
                        : ("test.yandex.ru"));

        api.userSteps.clientSteps().updateClientInfo(clientMap);
        ClientInfo clientInfoAfter = api.userSteps.clientSteps().getClientInfo(agencyLogin);

        assertThat("Вернулись некорректные значения Agency полей агентства", clientInfoAfter,
                BeanEquals.beanEquals(clientInfoBefore).byFields(
                        ClientInfoMap.AGENCY_NAME,
                        ClientInfoMap.AGENCY_STATUS,
                        ClientInfoMap.AGENCY_URL
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5860")
    public void updateAgencyNameBySubclientTest()  {
        api.as(managerLogin);
        ClientInfoMap agencyMap = new ClientInfoMap<>((ClientInfo)api.userSteps.clientSteps().getClientInfo(agencyLogin));
        api.as(clientLogin).userSteps.shouldGetErrorOn(Method.UPDATE_CLIENT_INFO,
                new ClientInfo[]{(ClientInfo) agencyMap.withAgencyName("Тестовое агентство").getBean()},
                new AxisError(251, AxisErrorDetails.EMPTY_STRING)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5861")
    public void updateAgencyNameByServicedClientNoRightsTest()  {
        api.as(managerLogin);
        ClientInfoMap agencyMap = new ClientInfoMap<>((ClientInfo)api.userSteps.clientSteps().getClientInfo(agencyLogin));

        api.as(clientLoginServ).userSteps.shouldGetErrorOn(Method.UPDATE_CLIENT_INFO,
                new ClientInfo[]{(ClientInfo) agencyMap.withAgencyName("Тестовое агентство").getBean()},
                new AxisError(251, null)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5862")
    public void updateClientInfoNoCityIdTest() {
        //https://jira.yandex-team.ru/browse/DIRECT-12571
        api.as(managerLogin);
        ClientInfoMap agencyMap = new ClientInfoMap<>((ClientInfo)api.userSteps.clientSteps().getClientInfo(agencyLogin));
        agencyMap.withCityId(null);
        api.userSteps.clientSteps().updateClientInfo(agencyMap);
    }

    @Test
    @Title("DIRECT-33335")
    @ru.yandex.qatools.allure.annotations.TestCaseId("5863")
    public void updateAgencyFieldsForServicedClientByManagerTest() {
        api.as(managerLogin);
        ClientInfoMap clientMap = new ClientInfoMap<>((ClientInfo)api.userSteps.clientSteps().getClientInfo(clientLoginServ));
        clientMap.withAgencyName("Unbelievable Agency Name");
        clientMap.withAgencyStatus("AA");
        clientMap.withAgencyUrl("serviced.client.url");
        api.userSteps.clientSteps().updateClientInfo(clientMap);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(clientLoginServ);

        assertThat("Вернулись некорректные значения Agency полей сервисируемого клиента", clientInfo,
                BeanEquals.beanEquals(new ClientInfoMap(api.type()).getBean()).byFields(
                        ClientInfoMap.AGENCY_NAME,
                        ClientInfoMap.AGENCY_STATUS,
                        ClientInfoMap.AGENCY_URL
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5864")
    public void updateAgencyFieldsManagerHimselfTest() {
        api.as(managerLogin);
        ClientInfoMap clientMap = new ClientInfoMap<>((ClientInfo)api.userSteps.clientSteps().getClientInfo(managerLogin));
        clientMap.withAgencyName("Unbelievable Agency Name");
        clientMap.withAgencyStatus("AA");
        clientMap.withAgencyUrl("manager.url");
        api.userSteps.clientSteps().updateClientInfo(clientMap);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(managerLogin);

        assertThat("Вернулись некорректные значения Agency полей менеджера", clientInfo,
                BeanEquals.beanEquals(new ClientInfoMap(api.type()).getBean()).byFields(
                        ClientInfoMap.AGENCY_NAME,
                        ClientInfoMap.AGENCY_STATUS,
                        ClientInfoMap.AGENCY_URL
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5865")
    public void updateAgencyFieldsByAgencyTest() {
        ClientInfo clientInfoBefore = api.as(managerLogin).userSteps.clientSteps().getClientInfo(agencyLogin);
        ClientInfoMap clientMap = new ClientInfoMap<>((ClientInfo)api.as(managerLogin).userSteps.clientSteps().getClientInfo(agencyLogin));
        clientMap.withAgencyName("Unbelievable Agency Name");
        clientMap.withAgencyStatus("SA");
        clientMap.withAgencyUrl("agency.url");
        api.as(agencyLogin).userSteps.clientSteps().updateClientInfo(clientMap);
        ClientInfo clientInfoAfter = api.as(managerLogin).userSteps.clientSteps().getClientInfo(agencyLogin);

        assertThat("Вернулись некорректные значения Agency полей агентства", clientInfoAfter,
                BeanEquals.beanEquals(clientInfoBefore).byFields(
                        ClientInfoMap.AGENCY_NAME,
                        ClientInfoMap.AGENCY_STATUS,
                        ClientInfoMap.AGENCY_URL
                ));
    }
}
