package ru.yandex.autotests.directapi.clients.updateclientinfo.agency.validation;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;


/**
 * Created by chicos on 19.06.14.
 *
 * https://jira.yandex-team.ru/browse/TESTIRT-2060
 */
@Aqua.Test
@Features(ClientFeatures.UPDATE_CLIENT_INFO)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateClientInfoValidationAgencyStatusTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String managerLogin = Logins.MANAGER_DEFAULT;
    private static final String agencyLogin = ClientLogins.AGENCY_ANOTHER_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(managerLogin).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public Object agencyStatus;

    @Parameterized.Parameter(value = 1)
    public AxisError expectedAxisError;

    @Parameterized.Parameters(name = "status = {0}")
    public static Collection statuses(){
        Object[][] data = new Object[][]{
                {Arrays.asList(), new AxisError(71, AxisErrorDetails.FIELD_MUST_BE_STRING, "AgencyStatus")},
                {Arrays.asList("AA"), new AxisError(71, AxisErrorDetails.FIELD_MUST_BE_STRING, "AgencyStatus")},
                {new String[]{null}, new AxisError(71, AxisErrorDetails.FIELD_MUST_BE_STRING, "AgencyStatus")},
                {123.45, new AxisError(71, AxisErrorDetails.AGENCY_STATUS_VALUES)},
                {"aa", new AxisError(71, AxisErrorDetails.AGENCY_STATUS_VALUES)},
                {"  AA ", new AxisError(71, AxisErrorDetails.AGENCY_STATUS_VALUES)},
                {-1, new AxisError(71, AxisErrorDetails.AGENCY_STATUS_VALUES)},
                //cyrillic AA
                {"АА", new AxisError(71, AxisErrorDetails.AGENCY_STATUS_VALUES)},
                {Collections.singletonMap("AgencyStatus", "AA"), new AxisError(71, AxisErrorDetails.FIELD_MUST_BE_STRING, "AgencyStatus")}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5867")
    public void setInvalidAgencyStatusByManagerTest() throws ParseException {
        ClientInfoMap agencyMap = new ClientInfoMap<>((ClientInfo)api.userSteps.clientSteps().getClientInfo(agencyLogin));
        List clientList = Collections.singletonList(agencyMap.getBean());
        JSONArray clientInfoBean = (JSONArray) new JSONParser().parse(JsonUtils.toString(clientList));
        ((JSONObject)clientInfoBean.get(0)).put(StringUtils.capitalize(ClientInfoMap.AGENCY_STATUS), agencyStatus);

        api.userSteps.shouldGetErrorOn(Method.UPDATE_CLIENT_INFO, clientInfoBean, expectedAxisError);
    }
}
