package ru.yandex.autotests.directapi.clients.updateclientinfo.rights;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.utils.matchers.IsApiBeanCollectionContaining;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientStories;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.common.api45mng.ClientRight;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * User: mariabye
 * Date: 27.02.13
 */

@Aqua.Test
@RunWith(Parameterized.class)
@Features(ClientFeatures.UPDATE_CLIENT_INFO)
@Stories(ClientStories.CLIENT_RIGHTS)
@Description("Супер, саппорт, менеджер могут редактировать права суб-клиентов агентства")
public class ClientRightsTurnOnOffTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameters(name = "Login = {0}")
    public static Collection roleValues() {
        Object[][] roleValues = new Object[][]{
                {Logins.SUPER_LOGIN},
                {Logins.SUPPORT},
                {Logins.MANAGER_DEFAULT},
        };
        return Arrays.asList(roleValues);
    }

    @Parameterized.Parameter
    public String login;

    private static String agencyLogin = Logins.AGENCY_YE_DEFAULT;
    private static String subClientLogin;

    @BeforeClass
    public static void initTest() {
        CreateNewSubclientResponse subClient =
                api.as(agencyLogin).userSteps.clientSteps().createNewAgencySubClient("at-d-ag", agencyLogin, Currency.RUB);
        subClientLogin = subClient.getLogin();
    }


    @Test
    @Title("Пользователь с внутренней ролью может редактировать права суб-клиентов агентства")
    @ru.yandex.qatools.allure.annotations.TestCaseId("5869")
    public void couldEditUserRights(){
        api.as(login);
        ClientInfo clientInfoBefore = api.userSteps.clientSteps().getClientInfo(subClientLogin);

        ClientInfoMap clientMap = new ClientInfoMap(clientInfoBefore)
                .withLogin(subClientLogin)
                .withPhone("+7000000")
                .withClientRights(agencyLogin,Value.YES,Value.YES, Value.YES);
        api.userSteps.clientSteps().updateClientInfo(clientMap);
        ClientInfo clientInfoAfter = api.userSteps.clientSteps().getClientInfo(subClientLogin);

        ClientRight[] expectedRights = ((ClientInfo)clientMap.getBean()).getClientRights();

        TestSteps.assertThat("набор прав верный", clientInfoAfter.getClientRights(),
                IsApiBeanCollectionContaining.hasItems(
                        BeanEquals.beanEquals(expectedRights[0]),
                        BeanEquals.beanEquals(expectedRights[1]),
                        BeanEquals.beanEquals(expectedRights[2])
                )
        );
    }
}
