package ru.yandex.autotests.directapi.clients.updateclientinfo.rights;

import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.utils.matchers.IsApiBeanCollectionContaining;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;


/**
 * Created by chicos on 23.06.14.
 * <p/>
 * https://jira.yandex-team.ru/browse/TESTIRT-2060
 */
@Aqua.Test
@Features(ApiFeatures.BUG)
public class ResetClientRightsByNullValueTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String agencyLogin = ClientLogins.AGENCY_FOR_UPDATES;
    private static final String subClientLogin = ClientLogins.SUBCLIENT_FOR_UPDATES;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(agencyLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();



    @Test
    @Title("DIRECT-32793")
    @ru.yandex.qatools.allure.annotations.TestCaseId("5870")
    public void resetClientRightsOnEmptySetTest() {
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(subClientLogin);
        ClientInfoMap clientMap = new ClientInfoMap(clientInfo)
                .withLogin(subClientLogin)
                .withClientRights(Value.YES,Value.NO,Value.YES);
        api.userSteps.clientSteps().updateClientInfo(clientMap);

        log.info("Передадим пустой набор полномочий");
        clientMap.withClientRights(null);
        api.userSteps.clientSteps().updateClientInfo(clientMap);
        ClientInfo clientInfoAfter = api.userSteps.clientSteps().getClientInfo(subClientLogin);

        log.info("Ожидаем выключенные полномочия для клиента");
        clientMap.withClientRights(Value.NO,Value.NO,Value.NO);

        assertThat("Набор прав верный", clientInfoAfter.getClientRights(),
                IsApiBeanCollectionContaining.hasItems(
                        BeanEquals.beanEquals(clientInfo.getClientRights()[0]),
                        BeanEquals.beanEquals(clientInfo.getClientRights()[1]),
                        BeanEquals.beanEquals(clientInfo.getClientRights()[2])
                )
        );
    }

}
