package ru.yandex.autotests.directapi.clients.updateclientinfo.rights;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.model.clients.ClientRightMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * Created by chicos on 27.06.14.
 *
 * * https://jira.yandex-team.ru/browse/TESTIRT-2060
 */
@Aqua.Test
@Features(ClientFeatures.UPDATE_CLIENT_INFO)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateClientInfoRightsNegativeTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String agencyLogin = ClientLogins.AGENCY_FOR_UPDATES;
    private static final String subClientLogin = ClientLogins.SUBCLIENT_RIGHTS_NEGATIVE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(agencyLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static ClientInfo clientInfo;

    @Parameterized.Parameter(value = 0)
    public String allowEditBefore;

    @Parameterized.Parameter(value = 1)
    public String allowImportBefore;

    @Parameterized.Parameter(value = 2)
    public String allowEdit;

    @Parameterized.Parameter(value = 3)
    public String allowImport;

    @Parameterized.Parameter(value = 4)
    public AxisError expectedError;

    @Parameterized.Parameters(name = "edit before = {0}, import before = {1}, set edit  = {2}, set import = {3}")
    public static Collection roles() {
        Object[][] data = new Object[][]{
                {Value.NO, Value.NO, null, Value.YES,
                        new AxisError(257, AxisErrorDetails.COULD_NOT_ALLOW_SUPER_SUPCLIENT_IMPORT_FROM_EXCEL)},
                {Value.YES, Value.NO, null, Value.YES,
                        new AxisError(257, AxisErrorDetails.COULD_NOT_ALLOW_SUPER_SUPCLIENT_IMPORT_FROM_EXCEL)},
                {Value.NO, Value.NO, Value.NO, Value.YES,
                        new AxisError(71, AxisErrorDetails.INCORRECT_RIGHT_STATUS)},
                {Value.YES, Value.NO, Value.NO, Value.YES,
                        new AxisError(71, AxisErrorDetails.INCORRECT_RIGHT_STATUS)},
                {Value.YES, Value.YES, Value.NO, Value.YES,
                        new AxisError(71, AxisErrorDetails.INCORRECT_RIGHT_STATUS)}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void getClientInfo(){
        clientInfo = api.userSteps.clientSteps().getClientInfo(subClientLogin);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareRightsState(){
        api.userSteps.clientSteps().updateClientInfo(
                new ClientInfoMap(clientInfo)
                .withClientRights(getClientRights(allowEditBefore, allowImportBefore))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5871")
    public void updateClientRights() {
        ClientInfo clientInfoBefore = api.userSteps.clientSteps().getClientInfo(subClientLogin);
        ClientInfoMap clientMap = new ClientInfoMap(clientInfoBefore)
                .withLogin(subClientLogin)
                .withClientRights(getClientRights(allowEdit, allowImport));
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CLIENT_INFO,
                new ClientInfo[]{(ClientInfo) clientMap.getBean()},
                expectedError
        );
    }

    /**
     * Return array of ClientRightMap for not null values
     *
     * @param allowEditValue
     * @param allowImportValue
     * @return
     */
    private ClientRightMap[] getClientRights(String allowEditValue, String allowImportValue) {
        List<ClientRightMap> list = new ArrayList<>();
        if (allowEditValue != null) {
            list.add(new ClientRightMap(api.type())
                    .allowEditCampaign(allowEditValue));
        }
        if (allowImportValue != null) {
            list.add(new ClientRightMap(api.type())
                    .allowImportXls(allowImportValue));
        }
        return list.toArray(new ClientRightMap[list.size()]);
    }
}
