package ru.yandex.autotests.directapi.clients.updateclientinfo.rights;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.clients.ClientStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.utils.matchers.IsApiBeanCollectionContaining;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.common.api45.ClientRight;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.qatools.allure.annotations.*;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;


/**
 * Created by chicos on 27.06.14.
 * <p/>
 * * https://jira.yandex-team.ru/browse/TESTIRT-2060
 */
@Aqua.Test
@Features(ClientFeatures.BUG)
@Stories(ClientStories.CLIENT_RIGHTS)
@Description("Выставление прав клиента при частичном указании значений прав.")
@RunWith(Parameterized.class)
public class UpdateClientInfoRightsPartialChangeTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String agencyLogin = ClientLogins.AGENCY_FOR_UPDATES;
    private static final String subClientLogin = ClientLogins.SUBCLIENT_FOR_CLIENT_RIGHTS;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(agencyLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static ClientInfo clientInfo;

    @Parameterized.Parameter(value = 0)
    public String allowEditBefore;

    @Parameterized.Parameter(value = 1)
    public String allowImportBefore;

    @Parameterized.Parameter(value = 2)
    public String allowTransferBefore;

    @Parameterized.Parameter(value = 3)
    public String allowEdit;

    @Parameterized.Parameter(value = 4)
    public String allowImport;

    @Parameterized.Parameter(value = 5)
    public String allowTransfer;

    @Parameterized.Parameter(value = 6)
    public String allowEditExpected;

    @Parameterized.Parameter(value = 7)
    public String allowImportExpected;

    @Parameterized.Parameter(value = 8)
    public String allowTransferExpected;

    @Parameterized.Parameters(name = "Edit/Import/Transfer: ({0}/{1}/{2}) ->({3}/{4}/{5}) ->({6}/{7}/{8})")
    public static Collection roles() {
        Object[][] data = new Object[][]{
                {Value.NO, Value.NO, Value.NO, null, null, null, Value.NO, Value.NO, Value.NO},
                {Value.NO, Value.NO, Value.NO, Value.YES, Value.YES, null, Value.YES, Value.YES, Value.NO},
                {Value.NO, Value.NO, Value.NO, null, null, Value.YES, Value.NO, Value.NO, Value.YES},
                {Value.NO, Value.NO, Value.NO, Value.YES, null, Value.YES, Value.YES, Value.NO, Value.YES},

                {Value.YES, Value.YES, Value.YES, null, null, null, Value.YES, Value.YES, Value.YES},
                {Value.YES, Value.YES, Value.YES, Value.NO, null, null, Value.NO, Value.NO, Value.YES},
                {Value.YES, Value.YES, Value.YES, null, null, Value.NO, Value.YES, Value.YES, Value.NO},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void getClientInfo() {
        clientInfo = api.userSteps.clientSteps().getClientInfo(subClientLogin);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareRightsState() {
        log.info("Установим перед тестом необходимое состояние субклиенту");
        api.userSteps.clientSteps().updateClientInfo(
                new ClientInfoMap(clientInfo)
                        .withClientRights(allowEditBefore, allowImportBefore, allowTransferBefore)
        );
    }

    @Test
    @Title("DIRECT-32793")
    @ru.yandex.qatools.allure.annotations.TestCaseId("5872")
    public void updateClientRights() {
        ClientInfo clientInfoBefore = api.userSteps.clientSteps().getClientInfo(subClientLogin);
        ClientRight[] rightsBefore = clientInfoBefore.getClientRights();
        ClientInfoMap clientMap = new ClientInfoMap(clientInfoBefore)
                .withLogin(subClientLogin)
                .withClientRights(allowEdit, allowImport, allowTransfer);
        api.userSteps.clientSteps().updateClientInfo(clientMap);
        ClientInfo clientInfoAfter = api.userSteps.clientSteps().getClientInfo(subClientLogin);

        clientMap = new ClientInfoMap(clientInfoBefore)
                .withClientRights(allowEditExpected, allowImportExpected, allowTransferExpected);
        ClientRight[] expectedRights = ((ClientInfo)clientMap.getBean()).getClientRights();
        TestSteps.assertThat("набор прав верный", clientInfoAfter.getClientRights(),
                IsApiBeanCollectionContaining.hasItems(
                        BeanEquals.beanEquals(expectedRights[0]),
                        BeanEquals.beanEquals(expectedRights[1]),
                        BeanEquals.beanEquals(expectedRights[2])
                )
        );

    }

}
