package ru.yandex.autotests.directapi.clients.updateclientinfo.rights;

import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.model.clients.ClientRightMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * Created by chicos on 23.06.14.
 *
 * https://jira.yandex-team.ru/browse/TESTIRT-2060
 */
@Aqua.Test
@Features(ClientFeatures.UPDATE_CLIENT_INFO)
@Tag(TagDictionary.TRUNK)
public class UpdateClientInfoRightsValidationTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String agencyLogin = ClientLogins.AGENCY_FOR_UPDATES;
    private static final String subClientLogin = ClientLogins.SUBCLIENT_RIGHTS_NEGATIVE;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5876")
    public void nonExistingRightTest() {
        api.as(agencyLogin);
        ClientInfoMap clientMap = new ClientInfoMap(api.type()).defaultClientInfo()
                .withLogin(subClientLogin)
                .withClientRights(new ClientRightMap(api.type())
                        .withRightName("NonExistingRight")
                        .withRightValue(Value.NO)
                );
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CLIENT_INFO,
                new ClientInfo[]{(ClientInfo) clientMap.getBean()},
                new AxisError(71, AxisErrorDetails.FIELD_RIGHT_NAME_MUST_CONTAIN_FOLLOWING_VALUES)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5874")
    public void emptyRightValueTest() {
        api.as(agencyLogin);
        ClientInfoMap clientMap = new ClientInfoMap(api.type()).defaultClientInfo()
                .withLogin(subClientLogin)
                .withClientRights(new ClientRightMap(api.type())
                        .allowEditCampaign(null)
                );
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CLIENT_INFO,
                new ClientInfo[]{(ClientInfo) clientMap.getBean()},
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "Value")
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5875")
    public void emptyRightNameTest() {
        api.as(agencyLogin);
        ClientInfoMap clientMap = new ClientInfoMap(api.type()).defaultClientInfo()
                .withLogin(subClientLogin)
                .withClientRights(new ClientRightMap(api.type())
                        .withRightValue(Value.NO)
                );
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CLIENT_INFO,
                new ClientInfo[]{(ClientInfo) clientMap.getBean()},
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "RightName")
        );
    }

}
