package ru.yandex.autotests.directapi.finance;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.greaterThan;

/**
 * User: mariabye
 * Date: 21.01.14
 */
@Aqua.Test
@Features(FinanceFeatures.BALANCE_INTEGRATION)
public class BalanceIntegrationSmokeTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5877")
    public void createAndPayAgencyCampaign() {
        api.as(Logins.AGENCY_RUB).userSteps.addActiveCampaign(Logins.SUBCLIENT_RUB,
                MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue(), Currency.RUB);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5878")
    public void getAgencyContract() {
        assertThat("Нет договоров у агентства",
                Integer.parseInt(User.get(Logins.AGENCY_RUB).getContractID()), greaterThan(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5879")
    public void createAndPayClientCampaign() {
        api.as(Logins.CLIENT_FOR_RUB).userSteps.addActiveCampaign(Logins.CLIENT_FOR_RUB,
                MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue(), Currency.RUB);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5880")
    public void getClientPersonID() {
        assertThat("Нет плательщиков у клиента",
                User.get(Logins.CLIENT_FOR_RUB).getPersonID(), greaterThan(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5881")
    public void createAndPayManagerCampaign() {
        api.as(Logins.MANAGER_DEFAULT).userSteps.addActiveCampaign(Logins.LOGIN_FOR_RUB,
                MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue(), Currency.RUB);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5882")
    public void notificationFromBalanceTest() {
        float sumForCreate = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue();
        long campaignId = api.as(Logins.AGENCY_RUB).userSteps
                .addActiveCampaign(Logins.SUBCLIENT_RUB, sumForCreate, Currency.RUB);
        ConditionFactories.NOTIFY_PAYMENT.until(
                api.userSteps.campaignSteps().campaignSumChanged(Logins.SUBCLIENT_RUB, campaignId, true));
    }
}
