package ru.yandex.autotests.directapi.finance.accountmanagement;


import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * User: mariabye
 * Date: 12.11.13
 * <p>
 * https://jira.yandex-team.ru/browse/DIRECT-25909
 */
@Aqua.Test
@Features(ApiFeatures.BUG)
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
public class DisabledForAccountThatTurnedOffTestFailed {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    public static String agencyLogin = FinanceLogins.AGENCY_ENABLE_SHARED_ACCOUNT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(agencyLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Account account;
    private static String subClientLogin;

    @BeforeClass
    public static void sharedAccountFlagOn() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(agencyLogin);
        api.userSteps.clientFakeSteps().enableToCreateSubClients(agencyLogin);
        CreateNewSubclientResponse subClient = api.userSteps.clientSteps()
                .createNewAgencySubClient("create", agencyLogin, Currency.RUB);
        subClientLogin = subClient.getLogin();
        api.userSteps.addDraftCampaign(subClientLogin);
        api.userSteps.financeSteps().enableSharedAccount(subClientLogin);
        account = api.userSteps.financeSteps().getAccount(subClientLogin);
    }

    @Test
    @Title("Bug DIRECT-29913")
    @ru.yandex.qatools.allure.annotations.TestCaseId("5944")
    public void getByLoginForAccountAllCampaignsDeleted() {
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(subClientLogin);
        Long[] campaignIDs = campaigns.stream().map(item -> item.getId()).toArray(Long[]::new);
        api.userSteps.campaignSteps().campaignsDelete(subClientLogin, campaignIDs);
        //DIRECT-29913
        api.userSteps.financeSteps()
                .shouldGetErrorsOnAccountManagementGet(
                        account.getLogin(),
                        new AxisError(520, AxisErrorDetails.EMPTY_STRING));
    }
}
