package ru.yandex.autotests.directapi.finance.accountmanagement.deposit;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.Payment;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: mariabye
 * Date: 17.10.13
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_DEPOSIT)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AmountTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static String contractID = User.get(FinanceLogins.AGENCY_DEPOSIT_1).getExternalContractID();

    @Parameterized.Parameter
    public PaymentMap payment;

    @Parameterized.Parameter(value = 1)
    public String operatorLogin;

    @Parameterized.Parameter(value = 2)
    public String clientLogin;

    @Parameterized.Parameter(value = 3)
    public boolean isYMOAUTH;

    @Parameterized.Parameters(name = "Operator = {1}")
    public static Collection payments() {
        Object[][] data = new Object[][]{
                {
                        new PaymentMap(api.type()).withContract(contractID),
                        FinanceLogins.AGENCY_DEPOSIT_1,
                        FinanceLogins.DEPOSIT_SC_1,
                        false},
//                {
//                        new PaymentMap(api.type()).withOrigin(PayMethod.OVERDRAFT),
//                        FinanceLogins.DEPOSIT_FREE_CLIENT,
//                        FinanceLogins.DEPOSIT_FREE_CLIENT,
//                        true},
//                {
//                        new PaymentMap(api.type()).withOrigin(PayMethod.YM),
//                        FinanceLogins.DEPOSIT_FREE_CLIENT,
//                        FinanceLogins.DEPOSIT_FREE_CLIENT,
//                        true
//                } до починки ЯД DIRECT-65926
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.as(FinanceLogins.AGENCY_DEPOSIT_1);
        api.userSteps.clientFakeSteps().enableAgencyWallet(FinanceLogins.AGENCY_DEPOSIT_1);
        api.userSteps.addModeratedCampaign(FinanceLogins.DEPOSIT_SC_1);
        api.userSteps.financeSteps().verifySharedAccount(FinanceLogins.DEPOSIT_SC_1);
        api.as(FinanceLogins.DEPOSIT_FREE_CLIENT).userSteps.addModeratedCampaign();
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.DEPOSIT_FREE_CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5966")
    public void set0Amount() {
        int accountID = api.as(operatorLogin).userSteps.financeSteps().getAccountID(clientLogin);
        payment.withAccountID(accountID);
        payment.withAmount(0f);
        payment.withCurrency(Currency.RUB);
        api.userSteps
                .financeSteps().shouldGetErrorOnAMDeposit(
                new AxisError(71, AxisErrorDetails.FIELD_VALUE_SHOULD_BE_MORE_THAN_0, "Payments[0].Amount"),
                isYMOAUTH, payment);

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5967")
    public void setLessThanAllowedAmountInCurrency() {
        int accountID = api.as(operatorLogin).userSteps.financeSteps().getAccountID(clientLogin);
        payment.withAccountID(accountID);
        payment.withAmount(MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().getPrevious().floatValue());
        payment.withCurrency(Currency.RUB.toString());
        api.userSteps.financeSteps().shouldGetErrorsOnAMDeposit(
                new PaymentMap[]{payment},
                isYMOAUTH,
                new AxisError(354, AxisErrorDetails.LOW_CURRENCY_PAYMENT_AMOUNT_FOR_ACCOUNT,
                        MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount()
                                .stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                        MoneyCurrency.get(Currency.RUB).getApiDescription(),
                        ((Payment) payment.getBean()).getAccountID()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5968")
    public void setLessThanAllowedAmount() {
        int accountID = api.as(operatorLogin).userSteps.financeSteps().getAccountID(clientLogin);
        payment.withAccountID(accountID);
        payment.withAmount(
                MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().getPrevious().floatValue());
        payment.withCurrency(Currency.RUB);
        api.userSteps.financeSteps().shouldGetErrorsOnAMDeposit(
                new PaymentMap[]{payment},
                isYMOAUTH,
                new AxisError(354, AxisErrorDetails.LOW_CURRENCY_PAYMENT_AMOUNT_FOR_ACCOUNT,
                        MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount()
                                .stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                        MoneyCurrency.get(Currency.RUB).getApiDescription(),
                        ((Payment) payment.getBean()).getAccountID()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5969")
    public void setNegativeAmount() {
        int accountID = api.as(operatorLogin).userSteps.financeSteps().getAccountID(clientLogin);
        payment.withAccountID(accountID);
        payment.withCurrency(Currency.RUB);
        payment.withAmount(-MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue());
        api.userSteps
                .financeSteps().shouldGetErrorOnAMDeposit(
                new AxisError(71, AxisErrorDetails.FIELD_VALUE_SHOULD_BE_MORE_THAN_0, "Payments[0].Amount"),
                isYMOAUTH, payment);
    }

}
