package ru.yandex.autotests.directapi.finance.accountmanagement.deposit;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;

/**
 * User: mariabye
 * Date: 16.10.13
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_DEPOSIT)
@Tag(TagDictionary.TRUNK)
public class DepositContractFieldTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String agencyLogin = FinanceLogins.AGENCY_DEPOSIT_1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(agencyLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static String agencySubclient1Login = FinanceLogins.DEPOSIT_SC_1;
    private static int accountID;
    private static Money minPaymentAmount;


    @BeforeClass
    public static void getAccountIDs() {
        api.as(agencyLogin);
        api.userSteps.clientFakeSteps().enableAgencyWallet(agencyLogin);
        api.userSteps.addModeratedCampaign(agencySubclient1Login);
        api.userSteps.financeSteps().verifySharedAccount(agencySubclient1Login);
        accountID = api.userSteps.financeSteps().getAccountID(agencySubclient1Login);
        minPaymentAmount = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5977")
    public void contractIs0() {
        api.userSteps.financeSteps().shouldGetErrorOnAMDeposit(
                new AxisError(71, AxisErrorDetails.FIELD_COMPLETED_INCORRECTLY, capitalize(PaymentMap.CONTRACT)),
                new PaymentMap(api.type())
                        .withAccountID(accountID)
                        .withCurrency(Currency.RUB)
                        .withAmount(minPaymentAmount.floatValue())
                        .withContract("0")
        );

    }

    //https://jira.yandex-team.ru/browse/DIRECT-26072
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5978")
    public void contractIsEmpty() {
        api.userSteps.financeSteps().shouldGetErrorOnAMDeposit(
                new AxisError(71, AxisErrorDetails.FIELD_COMPLETED_INCORRECTLY, capitalize(PaymentMap.CONTRACT)),
                new PaymentMap(api.type())
                        .withAccountID(accountID)
                        .withCurrency(Currency.RUB)
                        .withAmount(minPaymentAmount.floatValue())
                        .withContract("")
        );

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5979")
    public void contractIsUndef() {
        api.userSteps.financeSteps().shouldGetErrorOnAMDeposit(
                new AxisError(71, AxisErrorDetails.ONLY_THE_ONE_OF_THE_FOLLOWING_FIELDS_IN_STRUCTURE_MUST_BE_COMPLETED,
                        "Origin, Contract", "Payments[0]"),
                new PaymentMap(api.type())
                        .withAccountID(accountID)
                        .withCurrency(Currency.RUB)
                        .withAmount(minPaymentAmount.floatValue())
                        .withContract(null)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5980")
    public void contractStartsWith0Exists() {
        api.userSteps.financeSteps().
                shouldGetErrorOnAMDeposit(
                        new AxisError(71, AxisErrorDetails.FIELD_COMPLETED_INCORRECTLY,
                                capitalize(PaymentMap.CONTRACT)),
                        new PaymentMap(api.type())
                                .withAccountID(accountID)
                                .withCurrency(Currency.RUB)
                                .withAmount(minPaymentAmount.floatValue())
                                .withContract("04000/13")
                );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5981")
    public void contractNoRight() {
        String contractNoRight = User.get(FinanceLogins.AGENCY_DEPOSIT_2).getExternalContractID();
        api.userSteps.financeSteps().shouldGetErrorsOnAMDeposit(
                new PaymentMap[]{new PaymentMap(api.type())
                        .withAccountID(accountID)
                        .withCurrency(Currency.RUB)
                        .withAmount(minPaymentAmount.floatValue())
                        .withContract(contractNoRight)},
                new AxisError(356, AxisErrorDetails.EMPTY_STRING));
    }
}
