package ru.yandex.autotests.directapi.finance.accountmanagement.deposit;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: mariabye
 * Date: 16.10.13
 */
@Aqua.Test
@Features(ApiFeatures.BUG)
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
public class DepositContractModeTestFailed {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static String agencyLogin = FinanceLogins.AGENCY_DEPOSIT_1;
    static String agencySubclient1Login = FinanceLogins.DEPOSIT_SC_4;
    private static int accountID1;
    private static Money minPaymentAmount;
    private static String agencyContract;


    @BeforeClass
    public static void getAccountIDs() {
        api.as(agencyLogin);
        api.userSteps.clientFakeSteps().enableAgencyWallet(agencyLogin);
        api.userSteps.createAccount(agencySubclient1Login);
        accountID1 = api.userSteps.financeSteps().getAccountID(agencySubclient1Login);
        api.userSteps.balanceSteps().synchronizeWithBalance(accountID1);
        minPaymentAmount = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount();
        agencyContract = User.get(agencyLogin).getExternalContractID();
    }

    @Test
    @Title("DIRECT-32680")
    @ru.yandex.qatools.allure.annotations.TestCaseId("5990")
    public void managerNoRightToPay() {
        api.as(FinanceLogins.MANAGER_LOGIN);
        api.userSteps.financeSteps().shouldGetErrorsOnAMDeposit(
                new PaymentMap[]{new PaymentMap(api.type())
                        .withAccountID(accountID1)
                        .withAmount(minPaymentAmount.floatValue())
                        .withContract(agencyContract)
                        .withCurrency(Currency.RUB)},
                new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }
}
