package ru.yandex.autotests.directapi.finance.accountmanagement.deposit;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayMethod;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: mariabye
 * Date: 16.10.13
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_DEPOSIT)
@Tag(TagDictionary.TRUNK)
public class DepositContractOriginFieldTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static String agencyLogin = FinanceLogins.AGENCY_DEPOSIT_1;
    static String agencySubclient1Login = FinanceLogins.DEPOSIT_SC_1;
    private static int accountAgencyID;
    private static int accountSelfID;
    private static String agencyContract;

    @BeforeClass
    public static void getAccountIDs() {
        api.as(agencyLogin);
        api.userSteps.clientFakeSteps().enableAgencyWallet(agencyLogin);
        api.userSteps.financeSteps().verifySharedAccount(agencySubclient1Login);
        api.as(FinanceLogins.INVOICE_FREE_CLIENT).userSteps.addModeratedCampaign(FinanceLogins.INVOICE_FREE_CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.INVOICE_FREE_CLIENT);
        api.as(FinanceLogins.DEPOSIT_FREE_CLIENT).userSteps.addModeratedCampaign(FinanceLogins.DEPOSIT_FREE_CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.DEPOSIT_FREE_CLIENT);
        accountAgencyID = api.as(agencyLogin).userSteps.financeSteps().getAccountID(agencySubclient1Login);
        agencyContract = User.get(agencyLogin).getExternalContractID();
        accountSelfID = api.as(FinanceLogins.DEPOSIT_FREE_CLIENT).userSteps.financeSteps()
                .getAccountID(FinanceLogins.DEPOSIT_FREE_CLIENT);
    }

    //@Test до починки ЯД DIRECT-65926
    @ru.yandex.qatools.allure.annotations.TestCaseId("5991")
    public void contractAndEmptyOriginByClient() {
        api.as(FinanceLogins.DEPOSIT_FREE_CLIENT)
                .userSteps.financeSteps().shouldGetErrorOnAMDeposit(
                new AxisError(71, AxisErrorDetails.FIELD_MUST_CONTAIN_FOLLOWING_VALUES,
                        "Payments[0].Origin", "Overdraft, YM"),
                true,
                new PaymentMap(api.type())
                        .withAccountID(accountSelfID)
                        .withAmount(1000f)
                        .withContract(agencyContract)
                        .withOrigin("")
        );
    }

    //@Test до починки ЯД DIRECT-65926
    @ru.yandex.qatools.allure.annotations.TestCaseId("5992")
    public void contractAndInvalidOriginByClient() {
        api.as(FinanceLogins.DEPOSIT_FREE_CLIENT)
                .userSteps.financeSteps().shouldGetErrorOnAMDeposit(
                new AxisError(71, AxisErrorDetails.FIELD_MUST_CONTAIN_FOLLOWING_VALUES,
                        "Payments[0].Origin", "Overdraft, YM"),
                true,
                new PaymentMap(api.type())
                        .withAccountID(accountSelfID)
                        .withAmount(1000f)
                        .withContract(agencyContract)
                        .withOrigin(PayMethod.BANK)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5993")
    public void contractAndYMByClientNoTokenTransferred() {
        api.userSteps.financeSteps().shouldGetErrorsOnAMDeposit(
                new PaymentMap[]{new PaymentMap(api.type())
                        .withAccountID(accountSelfID)
                        .withAmount(1000f)
                        .withCurrency(Currency.RUB)
                        .withContract(agencyContract)
                        .withOrigin(PayMethod.YM)},
                new AxisError(360, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5994")
    public void contractAndYMByAgency() {
        api.as(FinanceLogins.AGENCY_DEPOSIT_1)
                .userSteps.financeSteps().shouldGetErrorOnAMDeposit(
                new AxisError(71,
                        AxisErrorDetails.ONLY_THE_ONE_OF_THE_FOLLOWING_FIELDS_IN_STRUCTURE_MUST_BE_COMPLETED,
                        "Origin, Contract", "Payments[0]"),
                new PaymentMap(api.type())
                        .withAccountID(accountAgencyID)
                        .withAmount(500f)
                        .withContract(agencyContract)
                        .withOrigin(PayMethod.YM)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5995")
    public void contractAndOverdraftByClient() {
        api.userSteps.financeSteps().shouldGetErrorsOnAMDeposit(
                new PaymentMap[]{new PaymentMap(api.type())
                        .withAccountID(accountSelfID)
                        .withAmount(50_000_000_000f)
                        .withCurrency(Currency.RUB)
                        .withContract(agencyContract)
                        .withOrigin(PayMethod.OVERDRAFT)},
                new AxisError(364, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5996")
    public void contractAndOverdraftByAgency() {
        api.as(FinanceLogins.AGENCY_DEPOSIT_1)
                .userSteps.financeSteps().shouldGetErrorOnAMDeposit(
                new AxisError(71,
                        AxisErrorDetails.ONLY_THE_ONE_OF_THE_FOLLOWING_FIELDS_IN_STRUCTURE_MUST_BE_COMPLETED,
                        "Origin, Contract", "Payments[0]"),
                new PaymentMap(api.type())
                        .withAccountID(accountAgencyID)
                        .withAmount(500000f)
                        .withContract(agencyContract)
                        .withOrigin(PayMethod.OVERDRAFT)
        );

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5997")
    public void contractAndOriginUndefForAgency() {
        api.as(FinanceLogins.AGENCY_DEPOSIT_1)
                .userSteps.financeSteps().shouldGetErrorOnAMDeposit(
                new AxisError(71,
                        AxisErrorDetails.ONLY_THE_ONE_OF_THE_FOLLOWING_FIELDS_IN_STRUCTURE_MUST_BE_COMPLETED,
                        "Origin, Contract", "Payments[0]"),
                new PaymentMap(api.type())
                        .withAccountID(accountAgencyID)
                        .withAmount(500f)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5998")
    public void contractAndOriginUndefForClient() {
        api.as(FinanceLogins.INVOICE_FREE_CLIENT)
                .userSteps.financeSteps().shouldGetErrorOnAMDeposit(
                new AxisError(71,
                        AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "Payments[0].Origin"),
                new PaymentMap(api.type())
                        .withAccountID(accountSelfID)
                        .withAmount(500f)
        );
    }
}
