package ru.yandex.autotests.directapi.finance.accountmanagement.deposit;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayMethod;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * User: mariabye
 * Date: 16.10.13
 */
@Aqua.Test
@Features(ApiFeatures.BUG)
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
public class DepositContractOriginFieldTestFailed {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static String agencyLogin = FinanceLogins.AGENCY_DEPOSIT_1;
    private static int accountSelfID;
    private static String agencyContract;

    @BeforeClass
    public static void getAccountIDs() {
        api.as(agencyLogin);
        api.userSteps.clientFakeSteps().enableAgencyWallet(agencyLogin);
        api.as(FinanceLogins.DEPOSIT_FREE_CLIENT).userSteps.addModeratedCampaign(FinanceLogins.DEPOSIT_FREE_CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.DEPOSIT_FREE_CLIENT);
        agencyContract = User.get(agencyLogin).getExternalContractID();
        accountSelfID = api.as(FinanceLogins.DEPOSIT_FREE_CLIENT).userSteps.financeSteps()
                .getAccountID(FinanceLogins.DEPOSIT_FREE_CLIENT);
    }

    @Test
    @Title("Bug DIRECT-32175")
    @ru.yandex.qatools.allure.annotations.TestCaseId("5999")
    public void contractAndYMByClient() {
        api.userSteps.financeSteps().shouldGetErrorsOnAMDeposit(
                new PaymentMap[]{new PaymentMap(api.type())
                        .withAccountID(accountSelfID)
                        .withAmount(1000f)
                        .withContract(agencyContract)
                        .withOrigin(PayMethod.YM)},
                true,
                new AxisError(365, AxisErrorDetails.SUM_EXCEEDED_LIMIT));
    }
}
