package ru.yandex.autotests.directapi.finance.accountmanagement.deposit;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_DEPOSIT)

public class YFTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String CONTRACT_ID = User.get(FinanceLogins.AGENCY_DEPOSIT_1).getExternalContractID();
    private static final String OPERATOR_LOGIN = FinanceLogins.AGENCY_DEPOSIT_1;
    private static final String CLIENT_LOGIN = FinanceLogins.DEPOSIT_SC_1;
    private static final PaymentMap paymentMap = new PaymentMap(api.type()).withContract(CONTRACT_ID);
    private static final Money MIN_INVOICE_AMOUNT = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount();

    @BeforeClass
    public static void initTest() {
        api.as(FinanceLogins.AGENCY_DEPOSIT_1);
        api.userSteps.clientFakeSteps().enableAgencyWallet(FinanceLogins.AGENCY_DEPOSIT_1);
        api.userSteps.addModeratedCampaign(FinanceLogins.DEPOSIT_SC_1);
        api.userSteps.financeSteps().verifySharedAccount(FinanceLogins.DEPOSIT_SC_1);
        api.as(FinanceLogins.DEPOSIT_FREE_CLIENT).userSteps.addModeratedCampaign(FinanceLogins.DEPOSIT_FREE_CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.DEPOSIT_FREE_CLIENT);
    }

    @Test
    public void depositWithNoCurrencyTest() {
        int accountID = api.as(OPERATOR_LOGIN).userSteps.financeSteps().getAccountID(CLIENT_LOGIN);
        paymentMap.withAccountID(accountID);
        paymentMap.withCurrency((Currency) null);
        paymentMap.withAmount(MIN_INVOICE_AMOUNT.convert(null).floatValue());

        api.userSteps.financeSteps().expectErrorOnAMDeposit(new AxisError(245), false, paymentMap);
    }

    @Test
    public void depositWithYndFixedTest() {
        int accountID = api.as(OPERATOR_LOGIN).userSteps.financeSteps().getAccountID(CLIENT_LOGIN);
        paymentMap.withAccountID(accountID);
        paymentMap.withCurrency((Currency) null);
        paymentMap.withAmount(MIN_INVOICE_AMOUNT.convert(null).floatValue());
        paymentMap.withCurrency(Currency.YND_FIXED);

        api.userSteps.financeSteps().expectErrorOnAMDeposit(new AxisError(245), false, paymentMap);
    }
}
