package ru.yandex.autotests.directapi.finance.accountmanagement.depositebycard;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountManagementRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;

/**
 * Created by semkagtn on 18.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_DEPOSIT_BY_CARD)
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@Description("Проверка валидации поля AccountID в запросе: негативные проверки")
@RunWith(Parameterized.class)
public class DepositByCardAccountIdValidationNegativeTest {

    private static final String CLIENT = FinanceLogins.DEPOSIT_BY_CARD_CLIENT4;
    private static final String ANOTHER_CLIENT = FinanceLogins.DEPOSIT_BY_CARD_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static long campaignId;
    private static long foreignAccountId;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public long accountId;

    @Parameterized.Parameter(2)
    public AxisError expectedError;

    @Parameterized.Parameters(name = "{0}: AccountID = {1}")
    public static Iterable<Object[]> data() {

        return Arrays.asList(new Object[][]{
                {"нулевой идентификатор общего счёта", 0L, new AxisError(54)},
                {"нулевой идентификатор кампании, не являющейся общимся счётом", campaignId, new AxisError(54)},
                {"идентификатор чужого общего счёта", foreignAccountId, new AxisError(54)},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.as(Logins.SUPER_LOGIN);
        api.userSteps.addModeratedCampaign(CLIENT);
        api.userSteps.financeSteps().verifySharedAccount(CLIENT);

        api.as(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);

        api.as(ANOTHER_CLIENT);
        foreignAccountId = api.userSteps.financeSteps().getAccountID(ANOTHER_CLIENT);
    }


    private static String customTransactionId =
            randomAlphanumeric(AccountManagementRequestMap.CUSTOM_TRANSACTION_ID_LENGTH);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6012")
    public void invalidAccountIdInRequest() {
        api.as(CLIENT);
        api.userSteps.financeSteps().shouldGetErrorsOnAMDepositByCard("invalidPayMethodId", customTransactionId, "20502A",
                new PaymentMap(api.type())
                        .withAccountID(accountId)
                        .withAmount(40.0f),
                expectedError);
    }
}
