package ru.yandex.autotests.directapi.finance.accountmanagement.depositebycard;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountManagementRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 22.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_DEPOSIT_BY_CARD)
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@Description("Проверка валидации поля Sum в запросе: негативные проверки")
@RunWith(Parameterized.class)
public class DepositByCardAmountValidationNegativeTest {

    private static final String CLIENT = FinanceLogins.DEPOSIT_BY_CARD_CLIENT4;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public float amount;

    @Parameterized.Parameter(2)
    public AxisError expectedError;

    @Parameterized.Parameters(name = "{0}: Sum = {1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"нулевая сумма", 0, new AxisError(71,
                        AxisErrorDetails.FIELD_VALUE_SHOULD_BE_MORE_THAN_0,
                        capitalize(AccountManagementRequestMap.PAYMENTS) + "[0]." + capitalize(PaymentMap.AMOUNT))},
                {"отрицательная сумма", -1, new AxisError(71,
                        AxisErrorDetails.FIELD_VALUE_SHOULD_BE_MORE_THAN_0,
                        capitalize(AccountManagementRequestMap.PAYMENTS) + "[0]." + capitalize(PaymentMap.AMOUNT))},
        });
    }

    private static String customTransactionId;
    private static int accountId;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.addModeratedCampaign(CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(CLIENT);
        accountId = api.as(CLIENT).userSteps.financeSteps().getAccountID(CLIENT);

        customTransactionId = randomAlphanumeric(AccountManagementRequestMap.CUSTOM_TRANSACTION_ID_LENGTH);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6013")
    public void invalidAmountInRequest() {
        api.as(CLIENT).userSteps.financeSteps().shouldGetErrorOn(Method.ACCOUNT_MANAGEMENT,
                new AccountManagementRequestMap<>(api.type())
                        .withAction(Action.DEPOSIT_BY_CARD)
                        .withPayMethodId("invalidLol")
                        .withVersion("20502A")
                        .withCustomTransactionId(customTransactionId)
                        .withPayments(new PaymentMap(api.type())
                                .withAccountID(accountId)
                                .withAmount(amount)),
                expectedError);
    }
}
