package ru.yandex.autotests.directapi.finance.accountmanagement.depositebycard;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.matchers.axiserror.ApiResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.balancesimple.request.BindCreditCardRequest;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountManagementRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_DEPOSIT_BY_CARD)
public class DepositByCardApplicationVersionTest {

    private static final String CLIENT = FinanceLogins.DEPOSIT_BY_CARD_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static String customTransactionId;
    private static int accountId;
    private static String payMethodId;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.addModeratedCampaign(CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(CLIENT);
        accountId = api.as(CLIENT).userSteps.financeSteps().getAccountID(CLIENT);

        api.as(CLIENT);
        customTransactionId = randomAlphanumeric(AccountManagementRequestMap.CUSTOM_TRANSACTION_ID_LENGTH);

        api.userSteps.balanceSimpleSteps().bindCreditCard(new BindCreditCardRequest().defaultCreditCard());
        payMethodId = api.userSteps.balanceSimpleSteps().getPaymentMethod();
    }

    @Test
    public void depositByCardNoApplicationVersion() {
        api.userSteps.financeSteps().shouldGetErrorsOnAMDepositByCard(
                payMethodId, customTransactionId, new PaymentMap(api.type())
                        .withAmount(MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue())
                        .withAccountID(accountId)
                        .withCurrency(Currency.RUB),
                new AxisError(365, AxisErrorDetails.PLEASE_UPDATE_APPLICATION));
    }

    @Test
    public void depositByCardWithApplicationVersion() {
        Object response = api.userSteps.financeSteps().depositByCard(
                payMethodId, customTransactionId, "20502A", new PaymentMap(api.type())
                        .withAmount(MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue())
                        .withAccountID(accountId)
                        .withCurrency(Currency.RUB));

        assumeThat("Ответ не содержит ошибок", JsonUtils.toString(response), ApiResponse.hasNoError());
    }
}
