package ru.yandex.autotests.directapi.finance.accountmanagement.depositebycard;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountManagementRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.apache.commons.lang3.RandomStringUtils.randomNumeric;
import static org.apache.commons.lang3.StringUtils.lowerCase;
import static org.apache.commons.lang3.StringUtils.upperCase;

/**
 * Created by semkagtn on 21.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_DEPOSIT_BY_CARD)
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@Description("Проверка валидации поля CustomTransactionID в запросе: позитивные проверки")
@RunWith(Parameterized.class)
public class DepositByCardCustomTransactionIdValidationPositiveTest {

    private static final String CLIENT = FinanceLogins.DEPOSIT_BY_CARD_CLIENT4;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String customTransactionId;

    @Parameterized.Parameters(name = "{0}: CustomTransactionID = {1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"только цифры", randomNumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH)},
                {"только маленькие буквы",
                        lowerCase(randomAlphabetic(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH))},
                {"только большие буквы",
                        upperCase(randomAlphabetic(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH))},
                {"маленькие и большие буквы", randomAlphabetic(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH)},
                {"буквы и цифры", randomAlphanumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH)},
        });
    }

    private static int accountId;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.addModeratedCampaign(CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(CLIENT);
        accountId = api.as(CLIENT).userSteps.financeSteps().getAccountID(CLIENT);

        api.as(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6016")
    public void validCustomTransactionIdInRequest() {
        api.userSteps.financeSteps().shouldGetMultipleErrorOn(Method.ACCOUNT_MANAGEMENT,
                new AccountManagementRequestMap<>(api.type())
                        .withAction(Action.DEPOSIT_BY_CARD)
                        .withPayMethodId("invalidPayMethod")
                        .withVersion("20502A")
                        .withCustomTransactionId(customTransactionId)
                        .withPayments(new PaymentMap(api.type())
                                .withAccountID(accountId)
                                .withCurrency(Currency.RUB)
                                .withAmount(1200.0f)).getBean(),
                new AxisError(368));
    }
}
