package ru.yandex.autotests.directapi.finance.accountmanagement.depositebycard;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountManagementRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 22.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_DEPOSIT_BY_CARD)
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@Description("Запрос с несколькими элементами в массиве Payments")
public class DepositByCardGreaterThanOnePaymentTest {

    private static final String CLIENT = FinanceLogins.DEPOSIT_BY_CARD_CLIENT4;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private String customTransactionId;
    private int accountId;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.userSteps.addModeratedCampaign(CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(CLIENT);
        accountId = api.as(CLIENT).userSteps.financeSteps().getAccountID(CLIENT);

        api.as(CLIENT);
        customTransactionId = randomAlphanumeric(AccountManagementRequestMap.CUSTOM_TRANSACTION_ID_LENGTH);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6018")
    public void twoSameCampaignIdsInRequest() {
        api.userSteps.financeSteps().shouldGetErrorOn(Method.ACCOUNT_MANAGEMENT,
                new AccountManagementRequestMap<>(api.type())
                        .withAction(Action.DEPOSIT_BY_CARD)
                        .withCustomTransactionId(customTransactionId)
                        .withPayMethodId("invalidPayMethodId")
                        .withVersion("20502A")
                        .withPayments(
                                new PaymentMap(api.type())
                                        .withAccountID(accountId)
                                        .withAmount(50.0f),
                                new PaymentMap(api.type())
                                        .withAccountID(accountId)
                                        .withAmount(90.0f)),
                new AxisError(241, AxisErrorDetails.THE_ARRAY_MUST_CONTAIN_NO_MORE_THAN_N_ELEMENTS,
                        capitalize(PayCampaignsByCardInfoMap.PAYMENTS), 1));
    }
}
