package ru.yandex.autotests.directapi.finance.accountmanagement.depositebycard;

import java.util.Arrays;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.balancesimple.request.BindCreditCardRequest;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountManagementRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 22.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_DEPOSIT_BY_CARD)
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@Description("Неверные по структуре запросы")
public class DepositByCardInvalidRequestTest {

    private static final String CLIENT = FinanceLogins.DEPOSIT_BY_CARD_CLIENT3;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static String customTransactionId;
    private static int accountId;
    private static String payMethodId;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.addModeratedCampaign(CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(CLIENT);
        accountId = api.as(CLIENT).userSteps.financeSteps().getAccountID(CLIENT);

        api.as(CLIENT);
        customTransactionId = randomAlphanumeric(AccountManagementRequestMap.CUSTOM_TRANSACTION_ID_LENGTH);
        payMethodId = api.userSteps.balanceSimpleSteps().bindCreditCard(new BindCreditCardRequest()
                .defaultCreditCard()).getPaymentMethod();
    }


    @Test
    @Description("Запрос без поля Payments")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6019")
    public void requestWithoutPayments() {
        api.userSteps.shouldGetErrorOn(Method.ACCOUNT_MANAGEMENT,
                new AccountManagementRequestMap<>(api.type())
                        .withAction(Action.DEPOSIT_BY_CARD)
                        .withVersion("20502A")
                        .withPayMethodId(payMethodId)
                        .withCustomTransactionId(customTransactionId).getBean(),
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY,
                        capitalize(AccountManagementRequestMap.PAYMENTS)));
    }

    @Test
    @Description("Запрос без поля AccountID")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6021")
    public void requestWithoutAccountId() {
        JSONObject payments = new JSONObject();
        payments.put(capitalize(PaymentMap.AMOUNT), 400.0f);

        JSONObject request = new JSONObject();
        request.put(capitalize(AccountManagementRequestMap.ACTION), Action.DEPOSIT_BY_CARD.getAction());
        request.put(capitalize(AccountManagementRequestMap.PAY_METHOD_ID), payMethodId);
        request.put(capitalize(AccountManagementRequestMap.CUSTOM_TRANSACTION_ID), customTransactionId);
        request.put(capitalize(AccountManagementRequestMap.PAYMENTS), Arrays.asList(payments));
        request.put(capitalize(AccountManagementRequestMap.VERSION), "20502A");

        api.userSteps.shouldGetErrorOn(Method.ACCOUNT_MANAGEMENT,
                request,
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY,
                        capitalize(AccountManagementRequestMap.PAYMENTS) + "[0]." + capitalize(PaymentMap.ACCOUNT_ID)));
    }

    @Test
    @Description("Запрос без поля Amount")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6020")
    public void requestWithoutAmount() {
        JSONObject payments = new JSONObject();
        payments.put(capitalize(PaymentMap.ACCOUNT_ID), accountId);

        JSONObject request = new JSONObject();
        request.put(capitalize(AccountManagementRequestMap.ACTION), Action.DEPOSIT_BY_CARD.getAction());
        request.put(capitalize(AccountManagementRequestMap.PAY_METHOD_ID), payMethodId);
        request.put(capitalize(AccountManagementRequestMap.CUSTOM_TRANSACTION_ID), customTransactionId);
        request.put(capitalize(AccountManagementRequestMap.PAYMENTS), Arrays.asList(payments));
        request.put(capitalize(AccountManagementRequestMap.VERSION), "20502A");

        api.userSteps.shouldGetErrorOn(Method.ACCOUNT_MANAGEMENT,
                request,
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY,
                        capitalize(AccountManagementRequestMap.PAYMENTS) + "[0]." + capitalize(PaymentMap.AMOUNT)));
    }
}
