package ru.yandex.autotests.directapi.finance.accountmanagement.depositebycard;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.balancesimple.request.BindCreditCardRequest;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountManagementRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;

/**
 * Created by semkagtn on 21.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_DEPOSIT_BY_CARD)
@Description("Проверка возможности передать в метод любую валюту")
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@RunWith(Parameterized.class)
public class DepositByCardNotAvailableCurrencyTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public Currency currency;

    @Parameterized.Parameter(1)
    public String client;

    @Parameterized.Parameters(name = "Currency = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Currency.KZT, FinanceLogins.DEPOSIT_BY_CARD_KZT},
                {Currency.EUR, FinanceLogins.DEPOSIT_BY_CARD_EUR},
                {Currency.USD, FinanceLogins.DEPOSIT_BY_CARD_USD},
                {Currency.CHF, FinanceLogins.DEPOSIT_BY_CARD_CHF},
                {Currency.TRY, FinanceLogins.DEPOSIT_BY_CARD_TRY},
        });
    }

    private static String customTransactionId = randomAlphanumeric(
            AccountManagementRequestMap.CUSTOM_TRANSACTION_ID_LENGTH);

    private int accountId;
    private String payMethodId;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.as(client);
        api.userSteps.addModeratedCampaign();
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(client);
        accountId = api.as(client).userSteps.financeSteps().getAccountID(client);

        accountId = api.userSteps.financeSteps().getAccountID(client);
        payMethodId = api.userSteps.balanceSimpleSteps().bindCreditCard(new BindCreditCardRequest()
                .defaultCreditCard()).getPaymentMethod();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6023")
    public void requestWithCurrency() {
        float sum = MoneyCurrency.get(currency).getMinInvoiceAmount().addVAT().floatValue() * 2;

        api.userSteps.financeSteps().shouldGetErrorsOnAMDepositByCard(payMethodId, customTransactionId, "20502A",
                new PaymentMap(api.type())
                        .withAccountID(accountId)
                        .withCurrency(currency)
                        .withAmount(sum),
                new AxisError(371, AxisErrorDetails.EMPTY_STRING));
    }
}
