package ru.yandex.autotests.directapi.finance.accountmanagement.depositebycard;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountManagementRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 22.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_DEPOSIT_BY_CARD)
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@Description("Проверка валидации поля PayMethodID в запросе: негативные проверки")
@RunWith(Parameterized.class)
public class DepositByCardPayMethodIdValidationNegativeTest {

    private static final String CLIENT = FinanceLogins.DEPOSIT_BY_CARD_CLIENT4;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String payMethodId;

    @Parameterized.Parameter(2)
    public AxisError expectedError;

    @Parameterized.Parameters(name = "{0}: PayMethodID = {1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"строка из пробела", " ", new AxisError(71, AxisErrorDetails.STRING_FIELD_SHOULD_NOT_BE_EMPTY,
                        capitalize(PayCampaignsByCardInfoMap.PAY_METHOD_ID))},

                {"пустая строка", "", new AxisError(71, AxisErrorDetails.STRING_FIELD_SHOULD_NOT_BE_EMPTY,
                        capitalize(PayCampaignsByCardInfoMap.PAY_METHOD_ID))},

                {"отсутствие значения", null, new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY,
                        capitalize(PayCampaignsByCardInfoMap.PAY_METHOD_ID))},
        });
    }

    private static String customTransactionId;
    private static int accountId;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.addModeratedCampaign(CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(CLIENT);
        accountId = api.as(CLIENT).userSteps.financeSteps().getAccountID(CLIENT);

        api.as(CLIENT);
        customTransactionId = randomAlphanumeric(AccountManagementRequestMap.CUSTOM_TRANSACTION_ID_LENGTH);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6024")
    public void invalidPayMethodIdInRequest() {
        api.userSteps.financeSteps().shouldGetErrorOn(Method.ACCOUNT_MANAGEMENT,
                new AccountManagementRequestMap<>(api.type())
                        .withAction(Action.DEPOSIT_BY_CARD)
                        .withPayMethodId(payMethodId)
                        .withVersion("20502A")
                        .withCustomTransactionId(customTransactionId)
                        .withPayments(new PaymentMap(api.type())
                                .withAccountID(accountId)
                                .withAmount(400.0f)),
                expectedError);
    }
}
